/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.AboutData;
import org.osgi.framework.Bundle;

public class ConfigurationLogDefaultSection
implements ISystemSummarySection {
    public void write(PrintWriter writer) {
        this.appendProperties(writer);
        this.appendFeatures(writer);
        this.appendRegistry(writer);
        this.appendUserPreferences(writer);
    }

    private void appendProperties(PrintWriter writer) {
        writer.println();
        writer.println(WorkbenchMessages.getString("SystemSummary.systemProperties"));
        Properties properties = System.getProperties();
        TreeSet<Object> set = new TreeSet<Object>(new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareTo(s2);
            }
        });
        set.addAll(properties.keySet());
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            writer.print(key);
            writer.print('=');
            writer.println(properties.get(key));
        }
    }

    private void appendFeatures(PrintWriter writer) {
        writer.println();
        writer.println(WorkbenchMessages.getString("SystemSummary.features"));
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        LinkedList<AboutBundleGroupData> groups = new LinkedList<AboutBundleGroupData>();
        if (providers != null) {
            for (int i = 0; i < providers.length; ++i) {
                IBundleGroup[] bundleGroups = providers[i].getBundleGroups();
                for (int j = 0; j < bundleGroups.length; ++j) {
                    groups.add(new AboutBundleGroupData(bundleGroups[j]));
                }
            }
        }
        AboutData[] bundleGroupInfos = groups.toArray(new AboutBundleGroupData[0]);
        AboutData.sortById(false, bundleGroupInfos);
        for (int i = 0; i < bundleGroupInfos.length; ++i) {
            AboutData info = bundleGroupInfos[i];
            Object[] args = new String[]{info.getId(), info.getVersion(), info.getName()};
            writer.println(WorkbenchMessages.format("SystemSummary.featureVersion", args));
        }
    }

    private void appendRegistry(PrintWriter writer) {
        int i;
        writer.println();
        writer.println(WorkbenchMessages.getString("SystemSummary.pluginRegistry"));
        Bundle[] bundles = WorkbenchPlugin.getDefault().getBundles();
        AboutData[] bundleInfos = new AboutBundleData[bundles.length];
        for (i = 0; i < bundles.length; ++i) {
            bundleInfos[i] = new AboutBundleData(bundles[i]);
        }
        AboutData.sortById(false, bundleInfos);
        for (i = 0; i < bundleInfos.length; ++i) {
            AboutData info = bundleInfos[i];
            Object[] args = new String[]{info.getId(), info.getVersion(), info.getName()};
            writer.println(WorkbenchMessages.format("SystemSummary.descriptorIdVersion", args));
        }
    }

    private void appendUserPreferences(PrintWriter writer) {
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences node = service.getRootNode();
        ByteArrayOutputStream stm = new ByteArrayOutputStream();
        try {
            service.exportPreferences(node, (OutputStream)stm, null);
        }
        catch (CoreException e) {
            writer.println("Error reading preferences " + e.toString());
        }
        writer.println();
        writer.println(WorkbenchMessages.getString("SystemSummary.userPreferences"));
        BufferedReader reader = null;
        try {
            int read;
            ByteArrayInputStream in = new ByteArrayInputStream(stm.toByteArray());
            reader = new BufferedReader(new InputStreamReader((InputStream)in, "8859_1"));
            char[] chars = new char[8192];
            while ((read = reader.read(chars)) > 0) {
                writer.write(chars, 0, read);
            }
        }
        catch (IOException e) {
            writer.println("Error reading preferences " + e.toString());
        }
    }
}

