/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectPreferences
extends EclipsePreferences {
    protected boolean isLoading = false;
    private int segmentCount;
    private String qualifier;
    private IProject project;
    private IEclipsePreferences loadLevel;
    private IFile file;
    protected static Set loadedNodes = new HashSet();
    private static IResourceChangeListener listener = ProjectPreferences.createListener();

    public ProjectPreferences() {
        super(null, null);
    }

    private ProjectPreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        String path = this.absolutePath();
        this.segmentCount = ProjectPreferences.getSegmentCount((String)path);
        if (this.segmentCount < 2) {
            return;
        }
        String projectName = ProjectPreferences.getSegment((String)path, (int)1);
        if (projectName != null) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (this.segmentCount > 2) {
            this.qualifier = ProjectPreferences.getSegment((String)path, (int)2);
        }
    }

    protected IPath getLocation() {
        if (this.project == null || this.qualifier == null) {
            return null;
        }
        IPath path = this.project.getLocation();
        return this.computeLocation(path, this.qualifier);
    }

    private static IResourceChangeListener createListener() {
        final IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IPath path = delta.getFullPath();
                int count = path.segmentCount();
                if (count < 2) {
                    return true;
                }
                if (count == 2) {
                    String name = path.segment(1);
                    return ".settings".equals(name);
                }
                if (count > 3) {
                    return false;
                }
                if (!"prefs".equals(path.getFileExtension())) {
                    return false;
                }
                String project = path.segment(0);
                String qualifier = path.removeFileExtension().lastSegment();
                IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
                Preferences node = root.node("project").node(project).node(qualifier);
                String message = null;
                try {
                    switch (delta.getKind()) {
                        case 2: {
                            message = Policy.bind("preferences.removeNodeException", node.absolutePath());
                            node.removeNode();
                            loadedNodes.remove(node.absolutePath());
                            break;
                        }
                        case 4: {
                            message = Policy.bind("preferences.syncException", node.absolutePath());
                            if (!(node instanceof ProjectPreferences)) break;
                            ((ProjectPreferences)node).load();
                        }
                    }
                }
                catch (BackingStoreException e) {
                    Status status = new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
                return false;
            }
        };
        IResourceChangeListener result = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                switch (event.getType()) {
                    case 1: {
                        this.handleDelta(event);
                        break;
                    }
                    case 4: {
                        this.handleProjectDelete(event);
                    }
                }
            }

            private void handleDelta(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                try {
                    delta.accept(visitor);
                }
                catch (CoreException e) {
                    String message = Policy.bind("preferences.visitException");
                    Status status = new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                }
            }

            private void handleProjectDelete(IResourceChangeEvent event) {
                IResource resource = event.getResource();
                if (resource == null) {
                    return;
                }
                Preferences scopeRoot = Platform.getPreferencesService().getRootNode().node("project");
                try {
                    if (!scopeRoot.nodeExists(resource.getName())) {
                        return;
                    }
                    scopeRoot.node(resource.getName()).removeNode();
                }
                catch (BackingStoreException e) {
                    String message = Policy.bind("preferences.projectDeleteException", resource.getName());
                    Status status = new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                }
            }
        };
        return result;
    }

    private static void addListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 5);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.absolutePath());
    }

    protected void loaded() {
        loadedNodes.add(this.absolutePath());
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            ProjectPreferences node = this;
            for (int i = 3; i < this.segmentCount; ++i) {
                node = (EclipsePreferences)node.parent();
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new ProjectPreferences(nodeParent, nodeName);
    }

    private IFile getFile() {
        if (this.file == null) {
            if (this.project == null || this.qualifier == null) {
                return null;
            }
            this.file = this.project.getFile(new Path(".settings").append(this.qualifier).addFileExtension("prefs"));
        }
        return this.file;
    }

    protected void save() throws BackingStoreException {
        IFile fileInWorkspace = this.getFile();
        if (fileInWorkspace == null) {
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Not saving preferences since there is no file for node: " + this.absolutePath());
            }
            return;
        }
        Properties table = this.convertToProperties(new Properties(), "");
        try {
            if (table.isEmpty()) {
                if (fileInWorkspace.exists()) {
                    IStatus status;
                    if (Policy.DEBUG_PREFERENCES) {
                        Policy.debug("Deleting preference file: " + fileInWorkspace.getFullPath());
                    }
                    if (fileInWorkspace.isReadOnly() && !(status = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, null)).isOK()) {
                        throw new CoreException(status);
                    }
                    try {
                        fileInWorkspace.delete(true, null);
                    }
                    catch (CoreException e) {
                        String message = Policy.bind("preferences.deleteException", fileInWorkspace.getFullPath().toString());
                        this.log((IStatus)new Status(2, "org.eclipse.core.resources", 2, message, null));
                    }
                }
                return;
            }
            table.put("eclipse.preferences.version", "1");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                table.store(output, null);
            }
            catch (IOException e) {
                String message = Policy.bind("preferences.saveProblems", this.absolutePath());
                this.log((IStatus)new Status(4, "org.eclipse.core.runtime", 4, message, (Throwable)e));
                throw new BackingStoreException(message);
            }
            finally {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
            BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(output.toByteArray()));
            if (fileInWorkspace.exists()) {
                IStatus status;
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug("Setting preference file contents for: " + fileInWorkspace.getFullPath());
                }
                if (fileInWorkspace.isReadOnly() && !(status = fileInWorkspace.getWorkspace().validateEdit(new IFile[]{fileInWorkspace}, null)).isOK()) {
                    throw new CoreException(status);
                }
                fileInWorkspace.setContents(input, 2, null);
            } else {
                IFolder folder = (IFolder)fileInWorkspace.getParent();
                if (!folder.exists()) {
                    if (Policy.DEBUG_PREFERENCES) {
                        Policy.debug("Creating parent preference directory: " + folder.getFullPath());
                    }
                    folder.create(0, true, null);
                }
                if (Policy.DEBUG_PREFERENCES) {
                    Policy.debug("Creating preference file: " + fileInWorkspace.getLocation());
                }
                fileInWorkspace.create((InputStream)input, 0, null);
            }
        }
        catch (CoreException e) {
            String message = Policy.bind("preferences.saveProblems", fileInWorkspace.getFullPath().toString());
            this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
            throw new BackingStoreException(message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() throws BackingStoreException {
        Properties fromDisk;
        block10: {
            IFile localFile = this.getFile();
            if (localFile == null || !localFile.exists()) {
                if (!Policy.DEBUG_PREFERENCES) return;
                Policy.debug("Unable to determine preference file or file does not exist for node: " + this.absolutePath());
                return;
            }
            if (Policy.DEBUG_PREFERENCES) {
                Policy.debug("Loading preferences from file: " + localFile.getFullPath());
            }
            fromDisk = new Properties();
            BufferedInputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(localFile.getContents(true));
                    fromDisk.load(input);
                }
                catch (CoreException e) {
                    String message = Policy.bind("preferences.loadException", localFile.getFullPath().toString());
                    this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
                catch (IOException e) {
                    String message = Policy.bind("preferences.loadException", localFile.getFullPath().toString());
                    this.log((IStatus)new Status(4, "org.eclipse.core.resources", 4, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
                Object var7_4 = null;
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (input == null) throw throwable;
                try {
                    ((InputStream)input).close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            ((InputStream)input).close();
        }
        this.convertFromProperties(fromDisk);
    }

    static {
        ProjectPreferences.addListener();
    }
}

