/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassGraphException;
import io.github.classgraph.ModulePathInfo;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.PackageInfo;
import io.github.classgraph.ScanResult;
import io.github.classgraph.Scanner;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.WhiteBlackList;
import nonapi.io.github.classgraph.classpath.SystemJarFinder;
import nonapi.io.github.classgraph.concurrency.AutoCloseableExecutorService;
import nonapi.io.github.classgraph.concurrency.InterruptionChecker;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.VersionFinder;

public class ClassGraph {
    ScanSpec scanSpec = new ScanSpec();
    private static final int DEFAULT_NUM_WORKER_THREADS = Math.max(2, (int)Math.ceil(Math.min(4.0, (double)Runtime.getRuntime().availableProcessors() * 0.75) + (double)Runtime.getRuntime().availableProcessors() * 1.25));
    private LogNode topLevelLog;

    public static String getVersion() {
        return VersionFinder.getVersion();
    }

    public ClassGraph verbose() {
        if (this.topLevelLog == null) {
            this.topLevelLog = new LogNode();
        }
        return this;
    }

    public ClassGraph enableAllInfo() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.enableMethodInfo();
        this.enableAnnotationInfo();
        this.enableStaticFinalFieldConstantInitializerValues();
        this.ignoreClassVisibility();
        this.ignoreFieldVisibility();
        this.ignoreMethodVisibility();
        return this;
    }

    public ClassGraph enableClassInfo() {
        this.scanSpec.enableClassInfo = true;
        return this;
    }

    public ClassGraph ignoreClassVisibility() {
        this.enableClassInfo();
        this.scanSpec.ignoreClassVisibility = true;
        return this;
    }

    public ClassGraph enableMethodInfo() {
        this.enableClassInfo();
        this.scanSpec.enableMethodInfo = true;
        return this;
    }

    public ClassGraph ignoreMethodVisibility() {
        this.enableClassInfo();
        this.enableMethodInfo();
        this.scanSpec.ignoreMethodVisibility = true;
        return this;
    }

    public ClassGraph enableFieldInfo() {
        this.enableClassInfo();
        this.scanSpec.enableFieldInfo = true;
        return this;
    }

    public ClassGraph ignoreFieldVisibility() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.scanSpec.ignoreFieldVisibility = true;
        return this;
    }

    public ClassGraph enableStaticFinalFieldConstantInitializerValues() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.scanSpec.enableStaticFinalFieldConstantInitializerValues = true;
        return this;
    }

    public ClassGraph enableAnnotationInfo() {
        this.enableClassInfo();
        this.scanSpec.enableAnnotationInfo = true;
        return this;
    }

    public ClassGraph enableInterClassDependencies() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.enableMethodInfo();
        this.enableAnnotationInfo();
        this.ignoreClassVisibility();
        this.ignoreFieldVisibility();
        this.ignoreMethodVisibility();
        this.scanSpec.enableInterClassDependencies = true;
        return this;
    }

    public ClassGraph disableRuntimeInvisibleAnnotations() {
        this.enableClassInfo();
        this.scanSpec.disableRuntimeInvisibleAnnotations = true;
        return this;
    }

    public ClassGraph disableJarScanning() {
        this.scanSpec.scanJars = false;
        return this;
    }

    public ClassGraph disableNestedJarScanning() {
        this.scanSpec.scanNestedJars = false;
        return this;
    }

    public ClassGraph disableDirScanning() {
        this.scanSpec.scanDirs = false;
        return this;
    }

    public ClassGraph disableModuleScanning() {
        this.scanSpec.scanModules = false;
        return this;
    }

    public ClassGraph enableExternalClasses() {
        this.enableClassInfo();
        this.scanSpec.enableExternalClasses = true;
        return this;
    }

    public ClassGraph initializeLoadedClasses() {
        this.scanSpec.initializeLoadedClasses = true;
        return this;
    }

    public ClassGraph removeTemporaryFilesAfterScan() {
        this.scanSpec.removeTemporaryFilesAfterScan = true;
        return this;
    }

    public ClassGraph overrideClasspath(String overrideClasspath) {
        this.scanSpec.overrideClasspath(overrideClasspath);
        return this;
    }

    public ClassGraph overrideClasspath(Iterable<?> overrideClasspathElements) {
        String overrideClasspath = JarUtils.pathElementsToPathStr(overrideClasspathElements);
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        this.overrideClasspath(overrideClasspath);
        return this;
    }

    public ClassGraph overrideClasspath(Object ... overrideClasspathElements) {
        String overrideClasspath = JarUtils.pathElementsToPathStr(overrideClasspathElements);
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        this.overrideClasspath(overrideClasspath);
        return this;
    }

    public ClassGraph filterClasspathElements(ClasspathElementFilter classpathElementFilter) {
        this.scanSpec.filterClasspathElements(classpathElementFilter);
        return this;
    }

    public ClassGraph addClassLoader(ClassLoader classLoader) {
        this.scanSpec.addClassLoader(classLoader);
        return this;
    }

    public ClassGraph overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        this.scanSpec.overrideClassLoaders(overrideClassLoaders);
        return this;
    }

    public ClassGraph ignoreParentClassLoaders() {
        this.scanSpec.ignoreParentClassLoaders = true;
        return this;
    }

    public ClassGraph addModuleLayer(Object moduleLayer) {
        this.scanSpec.addModuleLayer(moduleLayer);
        return this;
    }

    public ClassGraph overrideModuleLayers(Object ... overrideModuleLayers) {
        this.scanSpec.overrideModuleLayers(overrideModuleLayers);
        return this;
    }

    public ClassGraph ignoreParentModuleLayers() {
        this.scanSpec.ignoreParentModuleLayers = true;
        return this;
    }

    public ClassGraph whitelistPackages(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            if (packageName.startsWith("!") || packageName.startsWith("-")) {
                throw new IllegalArgumentException("This style of whitelisting/blacklisting is no longer supported: " + packageName);
            }
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(packageName));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName) + "/");
            if (packageName.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(packageName) + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName) + "/");
        }
        return this;
    }

    public ClassGraph whitelistPaths(String ... paths) {
        for (String path : paths) {
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.pathToPackageName(path));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePath(path) + "/");
            if (path.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToWhitelist(WhiteBlackList.pathToPackageName(path) + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePath(path) + "/");
        }
        return this;
    }

    public ClassGraph whitelistPackagesNonRecursive(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            if (packageName.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + packageName);
            }
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(packageName));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName) + "/");
        }
        return this;
    }

    public ClassGraph whitelistPathsNonRecursive(String ... paths) {
        for (String path : paths) {
            if (path.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + path);
            }
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.pathToPackageName(path));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePath(path) + "/");
        }
        return this;
    }

    public ClassGraph blacklistPackages(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            this.scanSpec.packageWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePackageOrClassName(packageName));
            this.scanSpec.pathWhiteBlackList.addToBlacklist(WhiteBlackList.packageNameToPath(packageName) + "/");
            if (packageName.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePackageOrClassName(packageName) + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToBlacklist(WhiteBlackList.packageNameToPath(packageName) + "/");
        }
        return this;
    }

    public ClassGraph blacklistPaths(String ... paths) {
        for (String path : paths) {
            this.scanSpec.packageWhiteBlackList.addToBlacklist(WhiteBlackList.pathToPackageName(path));
            this.scanSpec.pathWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePath(path) + "/");
            if (path.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToBlacklist(WhiteBlackList.pathToPackageName(path) + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePath(path) + "/");
        }
        return this;
    }

    public ClassGraph whitelistClasses(String ... classNames) {
        this.enableClassInfo();
        for (String className : classNames) {
            if (className.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + className);
            }
            this.scanSpec.classWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(className));
            this.scanSpec.classfilePathWhiteBlackList.addToWhitelist(WhiteBlackList.classNameToClassfilePath(className));
            String packageName = PackageInfo.getParentPackageName(className);
            this.scanSpec.classPackageWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(packageName));
            this.scanSpec.classPackagePathWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName) + "/");
        }
        return this;
    }

    public ClassGraph blacklistClasses(String ... classNames) {
        this.enableClassInfo();
        for (String className : classNames) {
            if (className.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + className);
            }
            this.scanSpec.classWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePackageOrClassName(className));
            this.scanSpec.classfilePathWhiteBlackList.addToBlacklist(WhiteBlackList.classNameToClassfilePath(className));
        }
        return this;
    }

    public ClassGraph whitelistJars(String ... jarLeafNames) {
        for (String jarLeafName : jarLeafNames) {
            String leafName = JarUtils.leafName(jarLeafName);
            if (!leafName.equals(jarLeafName)) {
                throw new IllegalArgumentException("Can only whitelist jars by leafname: " + jarLeafName);
            }
            this.scanSpec.jarWhiteBlackList.addToWhitelist(leafName);
        }
        return this;
    }

    public ClassGraph blacklistJars(String ... jarLeafNames) {
        for (String jarLeafName : jarLeafNames) {
            String leafName = JarUtils.leafName(jarLeafName);
            if (!leafName.equals(jarLeafName)) {
                throw new IllegalArgumentException("Can only blacklist jars by leafname: " + jarLeafName);
            }
            this.scanSpec.jarWhiteBlackList.addToBlacklist(leafName);
        }
        return this;
    }

    private void whitelistOrBlacklistLibOrExtJars(boolean whitelist, String ... jarLeafNames) {
        if (jarLeafNames.length == 0) {
            for (String libOrExtJar : SystemJarFinder.getJreLibOrExtJars()) {
                this.whitelistOrBlacklistLibOrExtJars(whitelist, JarUtils.leafName(libOrExtJar));
            }
        } else {
            for (String jarLeafName : jarLeafNames) {
                String leafName = JarUtils.leafName(jarLeafName);
                if (!leafName.equals(jarLeafName)) {
                    throw new IllegalArgumentException("Can only " + (whitelist ? "whitelist" : "blacklist") + " jars by leafname: " + jarLeafName);
                }
                if (jarLeafName.contains("*")) {
                    Pattern pattern = WhiteBlackList.globToPattern(jarLeafName);
                    boolean found = false;
                    for (String libOrExtJarPath : SystemJarFinder.getJreLibOrExtJars()) {
                        String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                        if (!pattern.matcher(libOrExtJarLeafName).matches()) continue;
                        if (!libOrExtJarLeafName.contains("*")) {
                            this.whitelistOrBlacklistLibOrExtJars(whitelist, libOrExtJarLeafName);
                        }
                        found = true;
                    }
                    if (found || this.topLevelLog == null) continue;
                    this.topLevelLog.log("Could not find lib or ext jar matching wildcard: " + jarLeafName);
                    continue;
                }
                boolean found = false;
                for (String libOrExtJarPath : SystemJarFinder.getJreLibOrExtJars()) {
                    String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                    if (!jarLeafName.equals(libOrExtJarLeafName)) continue;
                    if (whitelist) {
                        this.scanSpec.libOrExtJarWhiteBlackList.addToWhitelist(jarLeafName);
                    } else {
                        this.scanSpec.libOrExtJarWhiteBlackList.addToBlacklist(jarLeafName);
                    }
                    if (this.topLevelLog != null) {
                        this.topLevelLog.log((whitelist ? "Whitelisting" : "Blacklisting") + " lib or ext jar: " + libOrExtJarPath);
                    }
                    found = true;
                    break;
                }
                if (found || this.topLevelLog == null) continue;
                this.topLevelLog.log("Could not find lib or ext jar: " + jarLeafName);
            }
        }
    }

    public ClassGraph whitelistLibOrExtJars(String ... jarLeafNames) {
        this.whitelistOrBlacklistLibOrExtJars(true, jarLeafNames);
        return this;
    }

    public ClassGraph blacklistLibOrExtJars(String ... jarLeafNames) {
        this.whitelistOrBlacklistLibOrExtJars(false, jarLeafNames);
        return this;
    }

    public ClassGraph whitelistModules(String ... moduleNames) {
        for (String moduleName : moduleNames) {
            this.scanSpec.moduleWhiteBlackList.addToWhitelist(moduleName);
        }
        return this;
    }

    public ClassGraph blacklistModules(String ... moduleNames) {
        for (String moduleName : moduleNames) {
            this.scanSpec.moduleWhiteBlackList.addToBlacklist(moduleName);
        }
        return this;
    }

    public ClassGraph whitelistClasspathElementsContainingResourcePath(String ... resourcePaths) {
        for (String resourcePath : resourcePaths) {
            this.scanSpec.classpathElementResourcePathWhiteBlackList.addToWhitelist(resourcePath);
        }
        return this;
    }

    public ClassGraph blacklistClasspathElementsContainingResourcePath(String ... resourcePaths) {
        for (String resourcePath : resourcePaths) {
            this.scanSpec.classpathElementResourcePathWhiteBlackList.addToBlacklist(resourcePath);
        }
        return this;
    }

    public ClassGraph enableRemoteJarScanning() {
        this.scanSpec.enableRemoteJarScanning = true;
        return this;
    }

    public ClassGraph enableSystemJarsAndModules() {
        this.enableClassInfo();
        this.scanSpec.enableSystemJarsAndModules = true;
        return this;
    }

    public ClassGraph enableRealtimeLogging() {
        this.verbose();
        LogNode.logInRealtime(true);
        return this;
    }

    public void scanAsync(final ExecutorService executorService, final int numParallelTasks, final ScanResultProcessor scanResultProcessor, final FailureHandler failureHandler) {
        if (scanResultProcessor == null) {
            throw new IllegalArgumentException("scanResultProcessor cannot be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("failureHandler cannot be null");
        }
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    new Scanner(ClassGraph.this.scanSpec, executorService, numParallelTasks, scanResultProcessor, failureHandler, ClassGraph.this.topLevelLog);
                }
                catch (InterruptedException e) {
                    failureHandler.onFailure(e);
                }
            }
        });
    }

    public Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks) {
        try {
            return executorService.submit(new Scanner(this.scanSpec, executorService, numParallelTasks, null, null, this.topLevelLog));
        }
        catch (InterruptedException e) {
            return executorService.submit(new Callable<ScanResult>(){

                @Override
                public ScanResult call() throws Exception {
                    throw e;
                }
            });
        }
    }

    public ScanResult scan(ExecutorService executorService, int numParallelTasks) {
        try {
            ScanResult scanResult = this.scanAsync(executorService, numParallelTasks).get();
            if (scanResult == null) {
                throw new NullPointerException();
            }
            return scanResult;
        }
        catch (InterruptedException | CancellationException e) {
            throw new ClassGraphException("Scan interrupted", e);
        }
        catch (ExecutionException e) {
            throw new ClassGraphException("Uncaught exception during scan", InterruptionChecker.getCause(e));
        }
    }

    public ScanResult scan(int numThreads) {
        try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(numThreads);){
            ScanResult scanResult = this.scan(executorService, numThreads);
            return scanResult;
        }
    }

    public ScanResult scan() {
        return this.scan(DEFAULT_NUM_WORKER_THREADS);
    }

    public List<File> getClasspathFiles() {
        this.scanSpec.performScan = false;
        try (ScanResult scanResult = this.scan();){
            List<File> list = scanResult.getClasspathFiles();
            return list;
        }
    }

    public String getClasspath() {
        return JarUtils.pathElementsToPathStr(this.getClasspathFiles());
    }

    public List<URL> getClasspathURLs() {
        this.scanSpec.performScan = false;
        try (ScanResult scanResult = this.scan();){
            List<URL> list = scanResult.getClasspathURLs();
            return list;
        }
    }

    public List<ModuleRef> getModules() {
        this.scanSpec.performScan = false;
        try (ScanResult scanResult = this.scan();){
            List<ModuleRef> list = scanResult.getModules();
            return list;
        }
    }

    public ModulePathInfo getModulePathInfo() {
        return this.scanSpec.modulePathInfo;
    }

    @FunctionalInterface
    public static interface FailureHandler {
        public void onFailure(Throwable var1);
    }

    @FunctionalInterface
    public static interface ScanResultProcessor {
        public void processScanResult(ScanResult var1);
    }

    @FunctionalInterface
    public static interface ClasspathElementFilter {
        public boolean includeClasspathElement(String var1);
    }
}

