/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassGraphException;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleReaderProxy;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.Scanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.recycler.RecycleOnClose;
import nonapi.io.github.classgraph.recycler.Recycler;
import nonapi.io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.URLPathEncoder;

class ClasspathElementModule
extends ClasspathElement {
    private final ModuleRef moduleRef;
    private final NestedJarHandler nestedJarHandler;
    private Recycler<ModuleReaderProxy, IOException> moduleReaderProxyRecycler;
    private final Set<String> allResourcePaths = new HashSet<String>();

    ClasspathElementModule(ModuleRef moduleRef, ClassLoader classLoader, NestedJarHandler nestedJarHandler, ScanSpec scanSpec) {
        super(classLoader, scanSpec);
        this.moduleRef = moduleRef;
        this.nestedJarHandler = nestedJarHandler;
    }

    @Override
    void open(WorkQueue<Scanner.ClasspathEntryWorkUnit> workQueueIgnored, LogNode log) throws InterruptedException {
        try {
            this.moduleReaderProxyRecycler = this.nestedJarHandler.moduleRefToModuleReaderProxyRecyclerMap.get(this.moduleRef, null);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassGraphException("Got unexpected exception", e);
        }
    }

    private Resource newResource(final String moduleResourcePath) {
        return new Resource(){
            private ModuleReaderProxy moduleReaderProxy;

            @Override
            public String getPath() {
                return moduleResourcePath;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return moduleResourcePath;
            }

            @Override
            public URL getURL() {
                try {
                    if (ClasspathElementModule.this.moduleRef.getLocationStr() != null) {
                        return new URL(URLPathEncoder.normalizeURLPath(ClasspathElementModule.this.moduleRef.getLocationStr() + "!/" + moduleResourcePath));
                    }
                    return new URL(URLPathEncoder.normalizeURLPath("jrt:/" + ClasspathElementModule.this.moduleRef.getName() + "/" + moduleResourcePath));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for module location: " + ClasspathElementModule.this.moduleRef.getLocationStr() + " ; path: " + moduleResourcePath);
                }
            }

            @Override
            public URL getClasspathElementURL() {
                try {
                    if (ClasspathElementModule.this.moduleRef.getLocation() == null) {
                        return new URL(new URL("jrt:/" + ClasspathElementModule.this.moduleRef.getName()).toString());
                    }
                    return ClasspathElementModule.this.moduleRef.getLocation().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for module classpath element: " + ClasspathElementModule.this.moduleRef.getLocationStr());
                }
            }

            @Override
            public File getClasspathElementFile() {
                return null;
            }

            @Override
            public ModuleRef getModuleRef() {
                return ClasspathElementModule.this.moduleRef;
            }

            @Override
            public synchronized ByteBuffer read() throws IOException {
                if (ClasspathElementModule.this.skipClasspathElement) {
                    throw new IOException("Module could not be opened");
                }
                this.markAsOpen();
                try {
                    this.moduleReaderProxy = (ModuleReaderProxy)ClasspathElementModule.this.moduleReaderProxyRecycler.acquire();
                    this.byteBuffer = this.moduleReaderProxy.read(moduleResourcePath);
                    this.length = this.byteBuffer.remaining();
                    return this.byteBuffer;
                }
                catch (OutOfMemoryError | SecurityException e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            synchronized InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                return new InputStreamOrByteBufferAdapter(this.open());
            }

            @Override
            public synchronized InputStream open() throws IOException {
                if (ClasspathElementModule.this.skipClasspathElement) {
                    throw new IOException("Module could not be opened");
                }
                this.markAsOpen();
                try {
                    this.moduleReaderProxy = (ModuleReaderProxy)ClasspathElementModule.this.moduleReaderProxyRecycler.acquire();
                    this.inputStream = new Resource.InputStreamResourceCloser(this, this.moduleReaderProxy.open(moduleResourcePath));
                    this.length = -1L;
                    return this.inputStream;
                }
                catch (SecurityException e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            public synchronized byte[] load() throws IOException {
                try {
                    this.read();
                    byte[] byteArray = this.byteBufferToByteArray();
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public synchronized void close() {
                super.close();
                if (this.byteBuffer != null) {
                    if (this.moduleReaderProxy != null) {
                        this.moduleReaderProxy.release(this.byteBuffer);
                    }
                    this.byteBuffer = null;
                }
                if (this.moduleReaderProxy != null) {
                    ClasspathElementModule.this.moduleReaderProxyRecycler.recycle(this.moduleReaderProxy);
                    this.moduleReaderProxy = null;
                }
                this.markAsClosed();
            }
        };
    }

    @Override
    Resource getResource(String relativePath) {
        return this.allResourcePaths.contains(relativePath) ? this.newResource(relativePath) : null;
    }

    @Override
    void scanPaths(LogNode log) {
        if (this.skipClasspathElement) {
            return;
        }
        if (this.scanned.getAndSet(true)) {
            throw new IllegalArgumentException("Already scanned classpath element " + this.toString());
        }
        String moduleLocationStr = this.moduleRef.getLocationStr();
        LogNode subLog = log == null ? null : log.log(moduleLocationStr, "Scanning module " + this.moduleRef.getName());
        try {
            RecycleOnClose<ModuleReaderProxy, IOException> moduleReaderProxyRecycleOnClose = this.moduleReaderProxyRecycler.acquireRecycleOnClose();
            try {
                List<String> resourceRelativePaths;
                try {
                    resourceRelativePaths = moduleReaderProxyRecycleOnClose.get().list();
                }
                catch (SecurityException e) {
                    if (subLog != null) {
                        subLog.log("Could not get resource list for module " + this.moduleRef.getName(), e);
                    }
                    if (moduleReaderProxyRecycleOnClose != null) {
                        moduleReaderProxyRecycleOnClose.close();
                    }
                    return;
                }
                Collections.sort(resourceRelativePaths);
                String prevParentRelativePath = null;
                ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
                for (String relativePath : resourceRelativePaths) {
                    if (relativePath.endsWith("/")) continue;
                    this.checkResourcePathWhiteBlackList(relativePath, log);
                    if (this.skipClasspathElement) {
                        return;
                    }
                    int lastSlashIdx = relativePath.lastIndexOf(47);
                    String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
                    boolean parentRelativePathChanged = !parentRelativePath.equals(prevParentRelativePath);
                    ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || parentRelativePathChanged ? this.scanSpec.dirWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
                    prevParentRelativePath = parentRelativePath;
                    prevParentMatchStatus = parentMatchStatus;
                    if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
                        if (subLog == null) continue;
                        subLog.log("Skipping blacklisted path: " + relativePath);
                        continue;
                    }
                    if (!this.allResourcePaths.add(relativePath) || parentMatchStatus != ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX && parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.classfileIsSpecificallyWhitelisted(relativePath)) && (!this.scanSpec.enableClassInfo || !relativePath.equals("module-info.class"))) continue;
                    Resource resource = this.newResource(relativePath);
                    this.addWhitelistedResource(resource, parentMatchStatus, subLog);
                }
                File moduleFile = this.moduleRef.getLocationFile();
                if (moduleFile != null && moduleFile.exists()) {
                    this.fileToLastModified.put(moduleFile, moduleFile.lastModified());
                }
            }
            finally {
                if (moduleReaderProxyRecycleOnClose != null) {
                    try {
                        moduleReaderProxyRecycleOnClose.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            if (subLog != null) {
                subLog.log("Exception opening module " + this.moduleRef.getName(), e);
            }
            this.skipClasspathElement = true;
        }
        this.finishScanPaths(subLog);
    }

    ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    @Override
    public String getModuleName() {
        String moduleName = this.moduleRef.getName();
        if (moduleName == null || moduleName.isEmpty()) {
            moduleName = this.moduleNameFromModuleDescriptor;
        }
        return moduleName == null || moduleName.isEmpty() ? null : moduleName;
    }

    @Override
    URI getURI() {
        return this.moduleRef.getLocation();
    }

    @Override
    File getFile() {
        URI location = this.moduleRef.getLocation();
        if (location != null && "file".equals(location.getScheme())) {
            return new File(location);
        }
        return null;
    }

    public String toString() {
        return this.moduleRef.toString();
    }
}

