/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.reporting.AbstractVersionsReportRenderer;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesModel;
import org.codehaus.plexus.i18n.I18N;

public class DependencyUpdatesReportRenderer<K extends DependencyUpdatesModel>
extends AbstractVersionsReportRenderer<K> {
    public DependencyUpdatesReportRenderer(I18N i18n, Sink sink, Locale locale, String bundleName, K model, boolean allowSnapshots) {
        super(i18n, sink, locale, bundleName, model, allowSnapshots);
    }

    @Override
    protected void renderDetails() {
        ((DependencyUpdatesModel)this.model).getAllUpdates().forEach(this::renderDependencyDetail);
    }

    @Override
    protected void renderSummaryTable() {
        this.renderTable("report.overview.dependency", ((DependencyUpdatesModel)this.model).getArtifactUpdates(), "report.overview.noDependency");
    }

    @Override
    protected void renderManagementSummaryTable() {
        this.renderTable("report.overview.dependencyManagement", ((DependencyUpdatesModel)this.model).getArtifactManagementUpdates(), "report.overview.noDependencyManagement");
    }

    protected void renderTable(String titleKey, Map<Dependency, ArtifactVersions> contents, String emptyKey) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(this.getText(titleKey));
        this.sink.sectionTitle2_();
        if (contents.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.getText(emptyKey));
            this.sink.paragraph_();
        } else {
            this.renderSummaryTable(contents, true);
        }
        this.sink.section2_();
    }

    @Override
    protected OverviewStats computeOverviewStats() {
        return OverviewStats.fromUpdates(((DependencyUpdatesModel)this.model).getAllUpdates().values(), this.newestUpdateCache, this.isAllowSnapshots());
    }

    protected void renderDependencyDetail(Dependency artifact, ArtifactVersions details) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId()));
        this.sink.sectionTitle2_();
        this.renderDependencyDetailTable(artifact, details, true);
        this.sink.section2_();
    }
}

