/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.Prefetchable;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import net.sf.fmj.media.BasicInputConnector;
import net.sf.fmj.media.BasicSinkModule;
import net.sf.fmj.media.Connector;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.util.ElapseTime;

public class BasicMuxModule
extends BasicSinkModule {
    protected Multiplexer multiplexer;
    protected Format[] inputs;
    protected InputConnector[] ics;
    protected boolean[] prefetchMarkers;
    protected boolean[] endMarkers;
    protected boolean[] resettedMarkers;
    protected boolean[] stopAtTimeMarkers;
    protected boolean[] paused;
    protected boolean[] prerollTrack;
    private Object[] pauseSync;
    protected ElapseTime[] elapseTime;
    protected boolean prefetching = false;
    protected boolean started = false;
    private boolean closed = false;
    private boolean failed = false;
    private Object prefetchSync = new Object();
    private float frameRate = 30.0f;
    private float lastFramesBehind = -1.0f;
    private int framesPlayed = 0;
    private VideoFormat rtpVideoFormat = null;
    private VideoFormat firstVideoFormat = null;
    public static String ConnectorNamePrefix = "input";
    private long bitsWritten = 0L;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");

    protected BasicMuxModule(Multiplexer m, Format[] inputs) {
        this.multiplexer = m;
        if (inputs != null) {
            this.ics = new InputConnector[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                MyInputConnector ic = new MyInputConnector();
                ic.setSize(1);
                ic.setModule(this);
                this.registerInputConnector(ConnectorNamePrefix + i, ic);
                this.ics[i] = ic;
                if (!(inputs[i] instanceof VideoFormat) || this.firstVideoFormat != null) continue;
                this.firstVideoFormat = (VideoFormat)inputs[i];
                String encoding = inputs[i].getEncoding().toUpperCase();
                if (!encoding.endsWith("RTP")) continue;
                this.rtpVideoFormat = this.firstVideoFormat;
            }
            this.inputs = inputs;
        }
        if (this.multiplexer != null && this.multiplexer instanceof Clock) {
            this.setClock((Clock)((Object)this.multiplexer));
        }
        this.setProtocol(0);
    }

    @Override
    public void abortPrefetch() {
        this.prefetching = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkEnd(int idx) {
        boolean[] blArray = this.endMarkers;
        synchronized (this.endMarkers) {
            this.endMarkers[idx] = true;
            for (int i = 0; i < this.endMarkers.length; ++i) {
                if (this.endMarkers[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPrefetch(int idx) {
        boolean[] blArray = this.prefetchMarkers;
        synchronized (this.prefetchMarkers) {
            this.prefetchMarkers[idx] = true;
            for (int i = 0; i < this.prefetchMarkers.length; ++i) {
                if (this.prefetchMarkers[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkResetted(int idx) {
        boolean[] blArray = this.resettedMarkers;
        synchronized (this.resettedMarkers) {
            this.resettedMarkers[idx] = true;
            for (int i = 0; i < this.resettedMarkers.length; ++i) {
                if (this.resettedMarkers[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkStopAtTime(int idx) {
        boolean[] blArray = this.stopAtTimeMarkers;
        synchronized (this.stopAtTimeMarkers) {
            this.stopAtTimeMarkers[idx] = true;
            for (int i = 0; i < this.stopAtTimeMarkers.length; ++i) {
                if (this.stopAtTimeMarkers[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectorPushed(InputConnector ic) {
        int idx = -1;
        if (this.ics[0] == ic) {
            idx = 0;
        } else if (this.ics[1] == ic) {
            idx = 1;
        } else {
            for (int i = 2; i < this.ics.length; ++i) {
                if (this.ics[i] != ic) continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                throw new RuntimeException("BasicMuxModule: unmatched input connector!");
            }
        }
        while (true) {
            if (this.paused[idx]) {
                Object i = this.pauseSync[idx];
                synchronized (i) {
                    try {
                        while (this.paused[idx] && !this.closed) {
                            this.pauseSync[idx].wait();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.stopTime <= -1L || this.elapseTime[idx].value < this.stopTime) break;
            this.paused[idx] = true;
            if (!this.checkStopAtTime(idx)) continue;
            if (this.multiplexer instanceof Drainable) {
                ((Drainable)((Object)this.multiplexer)).drain();
            }
            this.doStop();
            if (this.moduleListener == null) continue;
            this.moduleListener.stopAtTime(this);
        }
        Buffer buffer = ic.getValidBuffer();
        int flags = buffer.getFlags();
        int rc = 0;
        if (this.resetted) {
            if ((flags & 0x200) != 0 && this.checkResetted(idx)) {
                this.resetted = false;
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            ic.readReport();
            return;
        }
        if (this.failed || this.closed || buffer.isDiscard()) {
            ic.readReport();
            return;
        }
        if ((flags & 0x400) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buffer);
            buffer.setFlags(flags &= 0xFFFFFBFF);
        }
        boolean dataPrerolled = false;
        Format format = buffer.getFormat();
        if (format == null) {
            format = ic.getFormat();
            buffer.setFormat(format);
        }
        if (this.elapseTime[idx].update(buffer.getLength(), buffer.getTimeStamp(), format)) {
            if (this.prerollTrack[idx]) {
                long target = this.getMediaNanoseconds();
                if (this.elapseTime[idx].value > target) {
                    if (format instanceof AudioFormat && "LINEAR".equals(format.getEncoding())) {
                        int remain = (int)ElapseTime.audioTimeToLen(this.elapseTime[idx].value - target, (AudioFormat)format);
                        int offset = buffer.getOffset() + buffer.getLength() - remain;
                        if (offset >= 0) {
                            buffer.setOffset(offset);
                            buffer.setLength(remain);
                        }
                    }
                    this.prerollTrack[idx] = false;
                    this.elapseTime[idx].setValue(target);
                } else {
                    dataPrerolled = true;
                }
            }
            if (this.stopTime > -1L && this.elapseTime[idx].value > this.stopTime && format instanceof AudioFormat) {
                long exceeded = this.elapseTime[idx].value - this.stopTime;
                int exceededLen = (int)ElapseTime.audioTimeToLen(exceeded, (AudioFormat)format);
                if (buffer.getLength() > exceededLen) {
                    buffer.setLength(buffer.getLength() - exceededLen);
                }
            }
        }
        if (this.moduleListener != null && format instanceof VideoFormat) {
            long mt = this.getMediaNanoseconds();
            long lateBy = mt / 1000000L - buffer.getTimeStamp() / 1000000L - this.getLatency() / 1000000L;
            float fb = (float)lateBy * this.frameRate / 1000.0f;
            if (fb < 0.0f) {
                fb = 0.0f;
            }
            if (this.lastFramesBehind != fb && (flags & 0x20) == 0) {
                this.moduleListener.framesBehind(this, fb, ic);
                this.lastFramesBehind = fb;
            }
        }
        do {
            if (!dataPrerolled) {
                block52: {
                    try {
                        rc = this.multiplexer.process(buffer, idx);
                    }
                    catch (Throwable e) {
                        Log.dumpStack(e);
                        if (this.moduleListener == null) break block52;
                        this.moduleListener.internalErrorOccurred(this);
                    }
                }
                if (rc == 0 && format == this.firstVideoFormat) {
                    if (format == this.rtpVideoFormat) {
                        if ((flags & 0x800) > 0) {
                            ++this.framesPlayed;
                        }
                    } else {
                        ++this.framesPlayed;
                    }
                }
            } else {
                rc = 0;
            }
            if ((rc & 8) != 0) {
                this.failed = true;
                if (this.moduleListener != null) {
                    this.moduleListener.pluginTerminated(this);
                }
                ic.readReport();
                return;
            }
            if (!this.prefetching || this.multiplexer instanceof Prefetchable && !((Prefetchable)((Object)this.multiplexer)).isPrefetched()) continue;
            Object object = this.prefetchSync;
            synchronized (object) {
                if (!this.started && this.prefetching && !this.resetted) {
                    this.paused[idx] = true;
                }
                if (this.checkPrefetch(idx)) {
                    this.prefetching = false;
                }
            }
            if (this.prefetching || this.moduleListener == null) continue;
            this.moduleListener.bufferPrefetched(this);
        } while (!this.resetted && rc == 2);
        this.bitsWritten += (long)buffer.getLength();
        if (buffer.isEOM()) {
            if (!this.resetted) {
                this.paused[idx] = true;
            }
            if (this.checkEnd(idx)) {
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.mediaEnded(this);
                }
            }
        }
        ic.readReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose() {
        this.multiplexer.close();
        this.closed = true;
        for (int i = 0; i < this.pauseSync.length; ++i) {
            Object object = this.pauseSync[i];
            synchronized (object) {
                this.pauseSync[i].notifyAll();
                continue;
            }
        }
    }

    @Override
    public void doDealloc() {
    }

    @Override
    public void doFailedPrefetch() {
        this.prefetching = false;
    }

    @Override
    public boolean doPrefetch() {
        if (!((PlaybackEngine)this.controller).prefetchEnabled) {
            return true;
        }
        this.resetPrefetchMarkers();
        this.prefetching = true;
        this.resume();
        return true;
    }

    @Override
    public boolean doRealize() {
        if (this.multiplexer == null || this.inputs == null) {
            return false;
        }
        try {
            this.multiplexer.open();
        }
        catch (ResourceUnavailableException e) {
            return false;
        }
        this.prefetchMarkers = new boolean[this.ics.length];
        this.endMarkers = new boolean[this.ics.length];
        this.resettedMarkers = new boolean[this.ics.length];
        this.stopAtTimeMarkers = new boolean[this.ics.length];
        this.paused = new boolean[this.ics.length];
        this.prerollTrack = new boolean[this.ics.length];
        this.pauseSync = new Object[this.ics.length];
        this.elapseTime = new ElapseTime[this.ics.length];
        for (int i = 0; i < this.ics.length; ++i) {
            this.prerollTrack[i] = false;
            this.pauseSync[i] = new Object();
            this.elapseTime[i] = new ElapseTime();
        }
        this.pause();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() {
        super.doStart();
        this.resetEndMarkers();
        this.resetStopAtTimeMarkers();
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.resume();
        }
    }

    @Override
    public void doStop() {
        super.doStop();
        this.started = false;
        this.resetPrefetchMarkers();
        this.prefetching = true;
    }

    public long getBitsWritten() {
        return this.bitsWritten;
    }

    @Override
    public Object getControl(String s) {
        return this.multiplexer.getControl(s);
    }

    @Override
    public Object[] getControls() {
        return this.multiplexer.getControls();
    }

    public DataSource getDataOutput() {
        return this.multiplexer.getDataOutput();
    }

    public int getFramesPlayed() {
        return this.framesPlayed;
    }

    public Multiplexer getMultiplexer() {
        return this.multiplexer;
    }

    @Override
    public boolean isThreaded() {
        return false;
    }

    void pause() {
        for (int i = 0; i < this.paused.length; ++i) {
            this.paused[i] = true;
        }
    }

    @Override
    protected void process() {
    }

    @Override
    public void reset() {
        super.reset();
        this.resetResettedMarkers();
        this.prefetching = false;
    }

    public void resetBitsWritten() {
        this.bitsWritten = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEndMarkers() {
        boolean[] blArray = this.endMarkers;
        synchronized (this.endMarkers) {
            for (int i = 0; i < this.endMarkers.length; ++i) {
                this.endMarkers[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void resetFramesPlayed() {
        this.framesPlayed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetPrefetchMarkers() {
        boolean[] blArray = this.prefetchMarkers;
        synchronized (this.prefetchMarkers) {
            for (int i = 0; i < this.prefetchMarkers.length; ++i) {
                this.prefetchMarkers[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetResettedMarkers() {
        boolean[] blArray = this.resettedMarkers;
        synchronized (this.resettedMarkers) {
            for (int i = 0; i < this.resettedMarkers.length; ++i) {
                this.resettedMarkers[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetStopAtTimeMarkers() {
        boolean[] blArray = this.stopAtTimeMarkers;
        synchronized (this.stopAtTimeMarkers) {
            for (int i = 0; i < this.stopAtTimeMarkers.length; ++i) {
                this.stopAtTimeMarkers[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        for (int i = 0; i < this.pauseSync.length; ++i) {
            Object object = this.pauseSync[i];
            synchronized (object) {
                this.paused[i] = false;
                this.pauseSync[i].notifyAll();
                continue;
            }
        }
    }

    @Override
    public void setFormat(Connector connector, Format format) {
        float fr;
        if (format instanceof VideoFormat && (fr = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = fr;
        }
    }

    @Override
    public void setPreroll(long wanted, long actual) {
        super.setPreroll(wanted, actual);
        for (int i = 0; i < this.elapseTime.length; ++i) {
            this.elapseTime[i].setValue(actual);
            this.prerollTrack[i] = !(this.inputs[i] instanceof AudioFormat) || !mpegAudio.matches(this.inputs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerReset() {
        this.multiplexer.reset();
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.resume();
            }
        }
    }

    class MyInputConnector
    extends BasicInputConnector {
        public String toString() {
            return super.toString() + ": " + this.getFormat();
        }
    }
}

