/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.util.function.Predicate;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTCPUtils;

public class AbstractRTPPacketPredicate
implements Predicate<ByteArrayBuffer> {
    private final boolean rtcp;

    public AbstractRTPPacketPredicate(boolean rtcp) {
        this.rtcp = rtcp;
    }

    @Override
    public boolean test(ByteArrayBuffer pkt) {
        if (pkt == null || !RawPacket.isRtpRtcp(pkt.getBuffer(), pkt.getOffset(), pkt.getLength())) {
            return false;
        }
        if (RTCPUtils.isRtcp(pkt.getBuffer(), pkt.getOffset(), pkt.getLength())) {
            return this.rtcp;
        }
        return !this.rtcp;
    }
}

