/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.fec;

import java.util.HashSet;
import java.util.Map;
import org.jitsi.impl.neomedia.transform.fec.AbstractFECReceiver;
import org.jitsi.impl.neomedia.transform.fec.FlexFec03Packet;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.ArrayUtils;
import org.jitsi.utils.logging.Logger;

public class FlexFec03Receiver
extends AbstractFECReceiver {
    private static final Logger logger = Logger.getLogger(FlexFec03Receiver.class);
    private Reconstructor reconstructor;

    public FlexFec03Receiver(long mediaSsrc, byte fecPayloadType) {
        super(mediaSsrc, fecPayloadType);
        this.reconstructor = new Reconstructor(this.mediaPackets);
    }

    @Override
    protected synchronized RawPacket[] doReverseTransform(RawPacket[] pkts) {
        HashSet<Integer> flexFecPacketsToRemove = new HashSet<Integer>();
        for (Map.Entry entry : this.fecPackets.entrySet()) {
            FlexFec03Packet flexFecPacket = FlexFec03Packet.create((RawPacket)entry.getValue());
            if (flexFecPacket == null) continue;
            this.reconstructor.setFecPacket(flexFecPacket);
            if (this.reconstructor.complete()) {
                flexFecPacketsToRemove.add(flexFecPacket.getSequenceNumber());
                continue;
            }
            if (!this.reconstructor.canRecover()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting recovery of missing sequence number " + this.reconstructor.missingSequenceNumber));
            }
            flexFecPacketsToRemove.add(flexFecPacket.getSequenceNumber());
            RawPacket recovered = this.reconstructor.recover();
            if (recovered != null) {
                logger.info((Object)("Recovered packet " + recovered.getSequenceNumber()));
                ++this.statistics.numRecoveredPackets;
                this.saveMedia(recovered);
                pkts = (RawPacket[])ArrayUtils.insert((Object)recovered, (Object[])pkts, RawPacket.class);
                continue;
            }
            logger.error((Object)("Recovery of packet " + this.reconstructor.missingSequenceNumber + " failed even though it should have been possible"));
            ++this.statistics.failedRecoveries;
        }
        for (Integer flexFecSeqNum : flexFecPacketsToRemove) {
            this.fecPackets.remove(flexFecSeqNum);
        }
        return pkts;
    }

    private static class Reconstructor {
        private Map<Integer, RawPacket> mediaPackets;
        private FlexFec03Packet fecPacket = null;
        int missingSequenceNumber = -1;
        int numMissing = -1;

        Reconstructor(Map<Integer, RawPacket> mediaPackets) {
            this.mediaPackets = mediaPackets;
        }

        public boolean complete() {
            return this.numMissing == 0;
        }

        public boolean canRecover() {
            return this.numMissing == 1;
        }

        public void setFecPacket(FlexFec03Packet p) {
            if (p == null) {
                logger.error((Object)"Error setting flexfec packet");
                return;
            }
            this.fecPacket = p;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Have " + this.mediaPackets.size() + " saved media packets"));
            }
            this.numMissing = 0;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reconstructor checking if recovery is possible: fec packet " + p.getSequenceNumber() + " protects packets:\n" + p.getProtectedSequenceNumbers()));
            }
            for (Integer protectedSeqNum : this.fecPacket.getProtectedSequenceNumbers()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Checking if we've received media packet " + protectedSeqNum));
                }
                if (this.mediaPackets.containsKey(protectedSeqNum)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"We haven't, mark as missing");
                }
                ++this.numMissing;
                this.missingSequenceNumber = protectedSeqNum;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("There were " + this.numMissing + " missing media packets for flexfec " + p.getSequenceNumber()));
            }
            if (this.numMissing > 1) {
                this.missingSequenceNumber = -1;
            }
        }

        private boolean startPacketRecovery(FlexFec03Packet fecPacket, RawPacket recoveredPacket) {
            if (fecPacket.getLength() < 12) {
                logger.error((Object)"Given FlexFEC packet is too small");
                return false;
            }
            if (recoveredPacket.getBuffer().length < fecPacket.getLength()) {
                logger.error((Object)"Given RawPacket buffer is too small");
                return false;
            }
            System.arraycopy(fecPacket.getBuffer(), fecPacket.getFlexFecHeaderOffset(), recoveredPacket.getBuffer(), 0, 12);
            System.arraycopy(fecPacket.getBuffer(), fecPacket.getFlexFecHeaderOffset() + fecPacket.getFlexFecHeaderSize(), recoveredPacket.getBuffer(), 12, fecPacket.getFlexFecPayloadLength());
            return true;
        }

        private void xorHeaders(RawPacket source, RawPacket dest) {
            byte[] byArray = dest.getBuffer();
            byArray[0] = (byte)(byArray[0] ^ source.getBuffer()[source.getOffset() + 0]);
            byte[] byArray2 = dest.getBuffer();
            byArray2[1] = (byte)(byArray2[1] ^ source.getBuffer()[source.getOffset() + 1]);
            int length = (source.getLength() & 0xFFFF) - 12;
            byte[] byArray3 = dest.getBuffer();
            byArray3[2] = (byte)(byArray3[2] ^ length >> 8);
            byte[] byArray4 = dest.getBuffer();
            byArray4[3] = (byte)(byArray4[3] ^ length & 0xFF);
            byte[] byArray5 = dest.getBuffer();
            byArray5[4] = (byte)(byArray5[4] ^ source.getBuffer()[source.getOffset() + 4]);
            byte[] byArray6 = dest.getBuffer();
            byArray6[5] = (byte)(byArray6[5] ^ source.getBuffer()[source.getOffset() + 5]);
            byte[] byArray7 = dest.getBuffer();
            byArray7[6] = (byte)(byArray7[6] ^ source.getBuffer()[source.getOffset() + 6]);
            byte[] byArray8 = dest.getBuffer();
            byArray8[7] = (byte)(byArray8[7] ^ source.getBuffer()[source.getOffset() + 7]);
        }

        private void xorPayloads(byte[] source, int sourceOffset, byte[] dest, int destOffset, int payloadLength) {
            for (int i = 0; i < payloadLength; ++i) {
                int n = destOffset + i;
                dest[n] = (byte)(dest[n] ^ source[sourceOffset + i]);
            }
        }

        private boolean finishPacketRecovery(FlexFec03Packet fecPacket, RawPacket recoveredPacket) {
            byte[] byArray = recoveredPacket.getBuffer();
            byArray[0] = (byte)(byArray[0] | 0x80);
            byte[] byArray2 = recoveredPacket.getBuffer();
            byArray2[0] = (byte)(byArray2[0] & 0xBF);
            int length = RTPUtils.readUint16AsInt(recoveredPacket.getBuffer(), 2);
            int lengthWithFixedHeader = length + 12;
            if (lengthWithFixedHeader > recoveredPacket.getBuffer().length) {
                logger.error((Object)"Length field of recovered packet is larger than its buffer");
                return false;
            }
            recoveredPacket.setLength(lengthWithFixedHeader);
            recoveredPacket.setSequenceNumber(this.missingSequenceNumber);
            recoveredPacket.setSSRC((int)fecPacket.getProtectedSsrc());
            return true;
        }

        private RawPacket recover() {
            if (!this.canRecover()) {
                return null;
            }
            byte[] buf = new byte[1500];
            RawPacket recoveredPacket = new RawPacket(buf, 0, 1500);
            if (!this.startPacketRecovery(this.fecPacket, recoveredPacket)) {
                return null;
            }
            for (Integer protectedSeqNum : this.fecPacket.getProtectedSequenceNumbers()) {
                if (protectedSeqNum == this.missingSequenceNumber) continue;
                RawPacket mediaPacket = this.mediaPackets.get(protectedSeqNum);
                this.xorHeaders(mediaPacket, recoveredPacket);
                this.xorPayloads(mediaPacket.getBuffer(), mediaPacket.getOffset() + 12, recoveredPacket.getBuffer(), 12, mediaPacket.getLength() - 12);
            }
            if (!this.finishPacketRecovery(this.fecPacket, recoveredPacket)) {
                return null;
            }
            return recoveredPacket;
        }
    }
}

