/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util;

import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.RawPacket;

public class RTCPUtils {
    public static int getPacketType(byte[] buf, int off, int len) {
        if (!RawPacket.isRtpRtcp(buf, off, len)) {
            return -1;
        }
        return buf[off + 1] & 0xFF;
    }

    public static int getPacketType(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1;
        }
        return RTCPUtils.getPacketType(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public static int getLength(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 4) {
            return -1;
        }
        int lengthInWords = (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
        return (lengthInWords + 1) * 4;
    }

    public static int getReportCount(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1;
        }
        return RTCPUtils.getReportCount(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    private static int getReportCount(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 1) {
            return -1;
        }
        return buf[off] & 0x1F;
    }

    public static int getLength(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1;
        }
        return RTCPUtils.getLength(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public static boolean isRtcp(byte[] buf, int off, int len) {
        if (!RawPacket.isRtpRtcp(buf, off, len)) {
            return false;
        }
        int pt = RTCPUtils.getPacketType(buf, off, len);
        return 200 <= pt && pt <= 211;
    }
}

