/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.event.ChatRoomConferencePublishedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomConferencePublishedListener;
import org.jxmpp.jid.parts.Resourcepart;

public abstract class AbstractChatRoom
implements ChatRoom {
    protected final List<ChatRoomConferencePublishedListener> conferencePublishedListeners = new LinkedList<ChatRoomConferencePublishedListener>();
    protected final Map<Resourcepart, ConferenceDescription> cachedConferenceDescriptions = new HashMap<Resourcepart, ConferenceDescription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConferencePublishedListener(ChatRoomConferencePublishedListener listener) {
        List<ChatRoomConferencePublishedListener> list = this.conferencePublishedListeners;
        synchronized (list) {
            this.conferencePublishedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConferencePublishedListener(ChatRoomConferencePublishedListener listener) {
        List<ChatRoomConferencePublishedListener> list = this.conferencePublishedListeners;
        synchronized (list) {
            this.conferencePublishedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ConferenceDescription> getCachedConferenceDescriptions() {
        HashMap<String, ConferenceDescription> tmpCachedConferenceDescriptions = new HashMap<String, ConferenceDescription>();
        Map<Resourcepart, ConferenceDescription> map = this.cachedConferenceDescriptions;
        synchronized (map) {
            for (Map.Entry<Resourcepart, ConferenceDescription> entry : this.cachedConferenceDescriptions.entrySet()) {
                tmpCachedConferenceDescriptions.put(entry.getKey().toString(), entry.getValue());
            }
        }
        return tmpCachedConferenceDescriptions;
    }

    @Override
    public synchronized int getCachedConferenceDescriptionSize() {
        return this.cachedConferenceDescriptions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConferencePublishedEvent(ChatRoomMember member, ConferenceDescription cd, int eventType) {
        LinkedList<ChatRoomConferencePublishedListener> listeners;
        ChatRoomConferencePublishedEvent evt = new ChatRoomConferencePublishedEvent(eventType, this, member, cd);
        List<ChatRoomConferencePublishedListener> list = this.conferencePublishedListeners;
        synchronized (list) {
            listeners = new LinkedList<ChatRoomConferencePublishedListener>(this.conferencePublishedListeners);
        }
        for (ChatRoomConferencePublishedListener listener : listeners) {
            listener.conferencePublished(evt);
        }
    }

    protected boolean processConferenceDescription(ConferenceDescription cd, Resourcepart participantName) {
        if (cd.isAvailable()) {
            if (this.cachedConferenceDescriptions.containsKey(participantName)) {
                return false;
            }
            this.cachedConferenceDescriptions.put(participantName, cd);
        } else {
            ConferenceDescription cachedDescription = this.cachedConferenceDescriptions.get(participantName);
            if (cachedDescription == null || !cd.compareConferenceDescription(cachedDescription)) {
                return false;
            }
            this.cachedConferenceDescriptions.remove(participantName);
        }
        return true;
    }

    protected void clearCachedConferenceDescriptionList() {
        this.cachedConferenceDescriptions.clear();
    }
}

