/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.signing;

import aQute.lib.base64.Base64;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import sun.security.util.ManifestDigester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSigner {
    private String alias;
    private PrivateKey privateKey;
    private X509Certificate[] certChain;

    public JarSigner(String alias, PrivateKey privateKey, X509Certificate[] certChain) {
        this.alias = alias;
        this.privateKey = privateKey;
        this.certChain = certChain;
    }

    private static String updateDigest(MessageDigest digest, InputStream inputStream) throws IOException {
        byte[] buffer = new byte[2048];
        int read = 0;
        while ((read = inputStream.read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        inputStream.close();
        Base64 base64 = new Base64(digest.digest());
        return base64.toString();
    }

    private static Map<String, Attributes> updateManifestDigest(Manifest manifest, Jar jarFile, MessageDigest[] messageDigests, Map<String, Attributes> entries) throws IOException {
        for (Map.Entry<String, Resource> jarEntry : jarFile.getResources().entrySet()) {
            if (jarEntry.getKey().startsWith("META-INF")) continue;
            Attributes attributes = entries.get(jarEntry.getKey());
            if (attributes == null) {
                attributes = new Attributes();
                entries.put(jarEntry.getKey(), attributes);
            }
            MessageDigest[] messageDigestArray = messageDigests;
            int n = messageDigests.length;
            int n2 = 0;
            while (n2 < n) {
                MessageDigest messageDigest = messageDigestArray[n2];
                String algorithm = messageDigest.getAlgorithm();
                attributes.putValue(String.valueOf(algorithm) + "-Digest", JarSigner.updateDigest(messageDigest, jarEntry.getValue().openInputStream()));
                ++n2;
            }
        }
        return entries;
    }

    private byte[] serialiseManifest(Manifest manifest) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        manifest.write(baos);
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    private SignatureFile createSignatureFile(Manifest manifest, MessageDigest[] messageDigests) throws Exception {
        ManifestDigester manifestDigester = new ManifestDigester(this.serialiseManifest(manifest));
        return new SignatureFile(messageDigests, manifest, manifestDigester, this.alias, true);
    }

    public void signJar(Jar jar) throws Exception {
        Manifest manifest = jar.getManifest();
        Map<String, Attributes> entries = manifest.getEntries();
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        MessageDigest[] messageDigests = new MessageDigest[]{sha1, md5};
        JarSigner.updateManifestDigest(manifest, jar, messageDigests, entries);
        SignatureFile signatureFile = this.createSignatureFile(manifest, messageDigests);
        SignatureFile.Block block = signatureFile.generateBlock(this.privateKey, this.certChain, true, null);
        String signatureFileName = signatureFile.getMetaName();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        signatureFile.write(bos);
        jar.putResource(signatureFileName, new EmbeddedResource(bos.toByteArray(), 0L));
        String signatureBlockName = block.getMetaName();
        bos = new ByteArrayOutputStream();
        block.write(bos);
        jar.putResource(signatureBlockName, new EmbeddedResource(bos.toByteArray(), 0L));
    }

    private static <T> Constructor<T> findConstructor(Class<T> c, Class<?> ... argTypes) throws NoSuchMethodException {
        Constructor<T> ct = c.getDeclaredConstructor(argTypes);
        ct.setAccessible(true);
        return ct;
    }

    private static <T> Method findMethod(Class<T> c, String methodName, Class<?> ... argTypes) throws NoSuchMethodException {
        Method m = c.getDeclaredMethod(methodName, argTypes);
        if (m == null) {
            throw new RuntimeException(c.getName());
        }
        m.setAccessible(true);
        return m;
    }

    public static JarSigner newInstance(String keystoreLocation, String alias, String passwd) throws Exception {
        FileInputStream fileIn = new FileInputStream(keystoreLocation);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(fileIn, passwd.toCharArray());
        return JarSigner.newInstance(keyStore, alias, passwd);
    }

    public static JarSigner newInstance(KeyStore keyStore, String alias, String passwd) throws Exception {
        Certificate[] chain = keyStore.getCertificateChain(alias);
        X509Certificate[] certChain = new X509Certificate[chain.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        int count = 0;
        while (count < chain.length) {
            X509Certificate cert;
            ByteArrayInputStream certIn = new ByteArrayInputStream(chain[count].getEncoded());
            certChain[count] = cert = (X509Certificate)cf.generateCertificate(certIn);
            ++count;
        }
        Key key = keyStore.getKey(alias, passwd.toCharArray());
        KeyFactory keyFactory = KeyFactory.getInstance(key.getAlgorithm());
        RSAPrivateKeySpec keySpec = keyFactory.getKeySpec(key, RSAPrivateKeySpec.class);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return new JarSigner(alias, privateKey, certChain);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SignatureFile {
        private Object sigFile;
        private Class<?> JDKsfClass = Class.forName("sun.security.tools.SignatureFile");
        private Method getMetaNameMethod;
        private Method writeMethod;
        private static final String JDK_SIGNATURE_FILE = "sun.security.tools.SignatureFile";
        private static final String GETMETANAME_METHOD = "getMetaName";
        private static final String WRITE_METHOD = "write";

        public SignatureFile(MessageDigest[] digests, Manifest mf, ManifestDigester md, String baseName, boolean signManifest) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
            Constructor constructor = JarSigner.findConstructor(this.JDKsfClass, new Class[]{MessageDigest[].class, Manifest.class, ManifestDigester.class, String.class, Boolean.TYPE});
            this.sigFile = constructor.newInstance(digests, mf, md, baseName, signManifest);
            this.getMetaNameMethod = JarSigner.findMethod(this.JDKsfClass, GETMETANAME_METHOD, new Class[0]);
            this.writeMethod = JarSigner.findMethod(this.JDKsfClass, WRITE_METHOD, new Class[]{OutputStream.class});
        }

        public Block generateBlock(PrivateKey privateKey, X509Certificate[] certChain, boolean externalSF, ZipFile zipFile) throws Exception {
            return new Block(this, privateKey, certChain, externalSF, zipFile);
        }

        public Class<?> getJDKSignatureFileClass() {
            return this.JDKsfClass;
        }

        public Object getJDKSignatureFile() {
            return this.sigFile;
        }

        public String getMetaName() throws IllegalAccessException, InvocationTargetException {
            return (String)this.getMetaNameMethod.invoke(this.sigFile, new Object[0]);
        }

        public void write(OutputStream os) throws IllegalAccessException, InvocationTargetException {
            this.writeMethod.invoke(this.sigFile, os);
        }

        private class Block {
            private Object block;
            private static final String JDK_BLOCK = "sun.security.tools.SignatureFile$Block";
            private static final String JDK_CONTENT_SIGNER = "com.sun.jarsigner.ContentSigner";
            private Method getMetaNameMethod;
            private Method writeMethod;

            public Block(SignatureFile sfg, PrivateKey privateKey, X509Certificate[] certChain, boolean externalSF, ZipFile zipFile) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                Class<?> blockClass = Class.forName(JDK_BLOCK);
                Class<?> contentSignerClass = Class.forName(JDK_CONTENT_SIGNER);
                Constructor constructor = JarSigner.findConstructor(blockClass, new Class[]{sfg.getJDKSignatureFileClass(), PrivateKey.class, X509Certificate[].class, Boolean.TYPE, String.class, X509Certificate.class, contentSignerClass, String[].class, ZipFile.class});
                this.getMetaNameMethod = JarSigner.findMethod(blockClass, SignatureFile.GETMETANAME_METHOD, new Class[0]);
                this.writeMethod = JarSigner.findMethod(blockClass, SignatureFile.WRITE_METHOD, new Class[]{OutputStream.class});
                this.block = constructor.newInstance(sfg.getJDKSignatureFile(), privateKey, certChain, externalSF, null, null, null, null, zipFile);
            }

            public String getMetaName() throws IllegalAccessException, InvocationTargetException {
                return (String)this.getMetaNameMethod.invoke(this.block, new Object[0]);
            }

            public void write(OutputStream os) throws IllegalAccessException, InvocationTargetException {
                this.writeMethod.invoke(this.block, os);
            }
        }
    }
}

