/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingle;

import java.util.Objects;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;

public class CryptoPacketExtension
extends AbstractPacketExtension {
    public static final String ELEMENT_NAME = "crypto";
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:1";
    public static final String CRYPTO_SUITE_ATTR_NAME = "crypto-suite";
    public static final String KEY_PARAMS_ATTR_NAME = "key-params";
    public static final String SESSION_PARAMS_ATTR_NAME = "session-params";
    public static final String TAG_ATTR_NAME = "tag";

    public CryptoPacketExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public CryptoPacketExtension(int tag, String cryptoSuite, String keyParams, String sessionParams) {
        this();
        this.setTag(Integer.toString(tag));
        this.setCryptoSuite(cryptoSuite);
        this.setKeyParams(keyParams);
        if (sessionParams != null) {
            this.setSessionParams(sessionParams);
        }
    }

    public void setCryptoSuite(String cryptoSuite) {
        super.setAttribute(CRYPTO_SUITE_ATTR_NAME, cryptoSuite);
    }

    public String getCryptoSuite() {
        return this.getAttributeAsString(CRYPTO_SUITE_ATTR_NAME);
    }

    public boolean equalsCryptoSuite(String cryptoSuite) {
        String currentCryptoSuite = this.getCryptoSuite();
        return CryptoPacketExtension.equalsStrings(currentCryptoSuite, cryptoSuite);
    }

    public void setKeyParams(String keyParams) {
        super.setAttribute(KEY_PARAMS_ATTR_NAME, keyParams);
    }

    public String getKeyParams() {
        return this.getAttributeAsString(KEY_PARAMS_ATTR_NAME);
    }

    public boolean equalsKeyParams(String keyParams) {
        String currentKeyParams = this.getKeyParams();
        return CryptoPacketExtension.equalsStrings(currentKeyParams, keyParams);
    }

    public void setSessionParams(String sessionParams) {
        super.setAttribute(SESSION_PARAMS_ATTR_NAME, sessionParams);
    }

    public String getSessionParams() {
        return this.getAttributeAsString(SESSION_PARAMS_ATTR_NAME);
    }

    public boolean equalsSessionParams(String sessionParams) {
        String currentSessionParams = this.getSessionParams();
        return CryptoPacketExtension.equalsStrings(currentSessionParams, sessionParams);
    }

    public void setTag(String tag) {
        super.setAttribute(TAG_ATTR_NAME, tag);
    }

    public String getTag() {
        return this.getAttributeAsString(TAG_ATTR_NAME);
    }

    public boolean equalsTag(String tag) {
        String currentTag = this.getTag();
        return CryptoPacketExtension.equalsStrings(currentTag, tag);
    }

    private static boolean equalsStrings(String string1, String string2) {
        return string1 == null && string2 == null || string1.equals(string2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CryptoPacketExtension) {
            CryptoPacketExtension crypto = (CryptoPacketExtension)obj;
            return crypto.equalsCryptoSuite(this.getCryptoSuite()) && crypto.equalsKeyParams(this.getKeyParams()) && crypto.equalsSessionParams(this.getSessionParams()) && crypto.equalsTag(this.getTag());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getCryptoSuite(), this.getKeyParams(), this.getSessionParams(), this.getTag());
    }
}

