/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.UpdateAvailableDeviceListListener;
import org.jitsi.utils.logging.Logger;

public abstract class AudioSystem2
extends AudioSystem {
    private static final Logger logger = Logger.getLogger(AudioSystem2.class);
    private int openStream = 0;
    private final Object openStreamSyncRoot = new Object();
    private int updateAvailableDeviceList = 0;
    private final List<WeakReference<UpdateAvailableDeviceListListener>> updateAvailableDeviceListListeners = new LinkedList<WeakReference<UpdateAvailableDeviceListListener>>();
    private final Object updateAvailableDeviceListSyncRoot = new Object();

    protected AudioSystem2(String locatorProtocol, int features) throws Exception {
        super(locatorProtocol, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateAvailableDeviceListListener(UpdateAvailableDeviceListListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<WeakReference<UpdateAvailableDeviceListListener>> list = this.updateAvailableDeviceListListeners;
        synchronized (list) {
            Iterator<WeakReference<UpdateAvailableDeviceListListener>> i = this.updateAvailableDeviceListListeners.iterator();
            boolean add = true;
            while (i.hasNext()) {
                UpdateAvailableDeviceListListener l = (UpdateAvailableDeviceListListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!l.equals(listener)) continue;
                add = false;
            }
            if (add) {
                this.updateAvailableDeviceListListeners.add(new WeakReference<UpdateAvailableDeviceListListener>(listener));
            }
        }
    }

    protected static void bubbleUpUsbDevices(List<CaptureDeviceInfo2> devices) {
        if (!devices.isEmpty()) {
            ArrayList<CaptureDeviceInfo2> nonUsbDevices = new ArrayList<CaptureDeviceInfo2>(devices.size());
            Iterator<CaptureDeviceInfo2> i = devices.iterator();
            while (i.hasNext()) {
                CaptureDeviceInfo2 d = i.next();
                if (d.isSameTransportType("USB")) continue;
                nonUsbDevices.add(d);
                i.remove();
            }
            if (!nonUsbDevices.isEmpty()) {
                for (CaptureDeviceInfo2 d : nonUsbDevices) {
                    devices.add(d);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didOpenStream() {
        Object object = this.openStreamSyncRoot;
        synchronized (object) {
            --this.openStream;
            if (this.openStream < 0) {
                this.openStream = 0;
            }
            this.openStreamSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void didUpdateAvailableDeviceList() {
        Object object = this.openStreamSyncRoot;
        synchronized (object) {
            --this.updateAvailableDeviceList;
            if (this.updateAvailableDeviceList < 0) {
                this.updateAvailableDeviceList = 0;
            }
            this.openStreamSyncRoot.notifyAll();
        }
        this.fireUpdateAvailableDeviceListEvent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUpdateAvailableDeviceListEvent(boolean will) {
        block11: {
            try {
                ArrayList<WeakReference<UpdateAvailableDeviceListListener>> ls;
                List<WeakReference<UpdateAvailableDeviceListListener>> list = this.updateAvailableDeviceListListeners;
                synchronized (list) {
                    ls = new ArrayList<WeakReference<UpdateAvailableDeviceListListener>>(this.updateAvailableDeviceListListeners);
                }
                for (WeakReference weakReference : ls) {
                    UpdateAvailableDeviceListListener l = (UpdateAvailableDeviceListListener)weakReference.get();
                    if (l == null) continue;
                    try {
                        if (will) {
                            l.willUpdateAvailableDeviceList();
                            continue;
                        }
                        l.didUpdateAvailableDeviceList();
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error((Object)("UpdateAvailableDeviceListListener." + (will ? "will" : "did") + "UpdateAvailableDeviceList failed."), t);
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block11;
                throw (ThreadDeath)t;
            }
        }
    }

    protected static void matchDevicesByName(List<CaptureDeviceInfo2> captureDevices, List<CaptureDeviceInfo2> playbackDevices) {
        Iterator<CaptureDeviceInfo2> captureIter = captureDevices.iterator();
        Pattern pattern = Pattern.compile("array|headphones|microphone|speakers|\\p{Space}|\\(|\\)", 2);
        LinkedList<CaptureDeviceInfo2> captureDevicesWithPlayback = new LinkedList<CaptureDeviceInfo2>();
        LinkedList<CaptureDeviceInfo2> playbackDevicesWithCapture = new LinkedList<CaptureDeviceInfo2>();
        int count = 0;
        while (captureIter.hasNext()) {
            CaptureDeviceInfo2 captureDevice = captureIter.next();
            String captureName = captureDevice.getName();
            if (captureName == null || (captureName = pattern.matcher(captureName).replaceAll("")).length() == 0) continue;
            Iterator<CaptureDeviceInfo2> playbackIter = playbackDevices.iterator();
            CaptureDeviceInfo2 matchingPlaybackDevice = null;
            while (playbackIter.hasNext()) {
                CaptureDeviceInfo2 playbackDevice = playbackIter.next();
                String playbackName = playbackDevice.getName();
                if (playbackName == null || !captureName.equals(playbackName = pattern.matcher(playbackName).replaceAll(""))) continue;
                playbackIter.remove();
                matchingPlaybackDevice = playbackDevice;
                break;
            }
            if (matchingPlaybackDevice == null) continue;
            captureIter.remove();
            captureDevicesWithPlayback.add(captureDevice);
            playbackDevicesWithCapture.add(matchingPlaybackDevice);
            ++count;
        }
        for (int i = count - 1; i >= 0; --i) {
            captureDevices.add(0, (CaptureDeviceInfo2)((Object)captureDevicesWithPlayback.get(i)));
            playbackDevices.add(0, (CaptureDeviceInfo2)((Object)playbackDevicesWithCapture.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitialize() throws Exception {
        Object object = this.updateAvailableDeviceListSyncRoot;
        synchronized (object) {
            this.willUpdateAvailableDeviceList();
            try {
                this.updateAvailableDeviceList();
            }
            finally {
                this.didUpdateAvailableDeviceList();
            }
        }
        AudioSystem2.invokeDeviceSystemInitialize(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateAvailableDeviceListListener(UpdateAvailableDeviceListListener listener) {
        if (listener == null) {
            return;
        }
        List<WeakReference<UpdateAvailableDeviceListListener>> list = this.updateAvailableDeviceListListeners;
        synchronized (list) {
            Iterator<WeakReference<UpdateAvailableDeviceListListener>> i = this.updateAvailableDeviceListListeners.iterator();
            while (i.hasNext()) {
                UpdateAvailableDeviceListListener l = (UpdateAvailableDeviceListListener)i.next().get();
                if (l != null && !l.equals(listener)) continue;
                i.remove();
            }
        }
    }

    protected abstract void updateAvailableDeviceList();

    private void waitForOpenStream() {
        boolean interrupted = false;
        while (this.openStream > 0) {
            try {
                this.openStreamSyncRoot.wait();
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void waitForUpdateAvailableDeviceList() {
        boolean interrupted = false;
        while (this.updateAvailableDeviceList > 0) {
            try {
                this.openStreamSyncRoot.wait();
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void willOpenStream() {
        Object object = this.openStreamSyncRoot;
        synchronized (object) {
            this.waitForUpdateAvailableDeviceList();
            ++this.openStream;
            this.openStreamSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void willUpdateAvailableDeviceList() {
        Object object = this.openStreamSyncRoot;
        synchronized (object) {
            this.waitForOpenStream();
            ++this.updateAvailableDeviceList;
            this.openStreamSyncRoot.notifyAll();
        }
        this.fireUpdateAvailableDeviceListEvent(true);
    }
}

