/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia.recording;

import org.jitsi.utils.MediaType;
import org.json.simple.JSONObject;

public class RecorderEvent {
    private Type type = Type.OTHER;
    private long instant = -1L;
    private long ssrc = -1L;
    private long audioSsrc = -1L;
    private long rtpTimestamp = -1L;
    private double ntpTime = -1.0;
    private long duration = -1L;
    private AspectRatio aspectRatio = AspectRatio.ASPECT_RATIO_UNKNOWN;
    private String filename;
    private MediaType mediaType = null;
    private String participantName = null;
    private String participantDescription = null;
    private String endpointId = null;
    private boolean disableOtherVideosOnTop = false;

    public RecorderEvent() {
    }

    public RecorderEvent(JSONObject json) {
        Object o = json.get((Object)"type");
        if (o != null) {
            this.type = Type.parseString(o.toString());
        }
        if ((o = json.get((Object)"instant")) != null && (o instanceof Long || o instanceof Integer)) {
            this.instant = (Long)o;
        }
        if ((o = json.get((Object)"ssrc")) != null && (o instanceof Long || o instanceof Integer)) {
            this.ssrc = (Long)o;
        }
        if ((o = json.get((Object)"audioSsrc")) != null && (o instanceof Long || o instanceof Integer)) {
            this.audioSsrc = (Long)o;
        }
        if ((o = json.get((Object)"ntpTime")) != null && (o instanceof Long || o instanceof Integer)) {
            this.ntpTime = ((Long)o).longValue();
        }
        if ((o = json.get((Object)"duration")) != null && (o instanceof Long || o instanceof Integer)) {
            this.duration = (Long)o;
        }
        if ((o = json.get((Object)"aspectRatio")) != null) {
            this.aspectRatio = AspectRatio.parseString(o.toString());
        }
        if ((o = json.get((Object)"filename")) != null) {
            this.filename = o.toString();
        }
        if ((o = json.get((Object)"participantName")) != null && o instanceof String) {
            this.participantName = (String)o;
        }
        if ((o = json.get((Object)"participantDescription")) != null && o instanceof String) {
            this.participantDescription = (String)o;
        }
        if ((o = json.get((Object)"endpointId")) != null && o instanceof String) {
            this.endpointId = (String)o;
        }
        if ((o = json.get((Object)"mediaType")) != null) {
            try {
                this.mediaType = MediaType.parseString((String)o.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((o = json.get((Object)"disableOtherVideosOnTop")) != null) {
            if (o instanceof Boolean) {
                this.disableOtherVideosOnTop = (Boolean)o;
            } else if (o instanceof String) {
                this.disableOtherVideosOnTop = Boolean.valueOf((String)o);
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public long getInstant() {
        return this.instant;
    }

    public void setInstant(long instant) {
        this.instant = instant;
    }

    public long getRtpTimestamp() {
        return this.rtpTimestamp;
    }

    public void setRtpTimestamp(long rtpTimestamp) {
        this.rtpTimestamp = rtpTimestamp;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }

    public long getAudioSsrc() {
        return this.audioSsrc;
    }

    public void setAudioSsrc(long audioSsrc) {
        this.audioSsrc = audioSsrc;
    }

    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getParticipantName() {
        return this.participantName;
    }

    public void setParticipantName(String participantName) {
        this.participantName = participantName;
    }

    public String getParticipantDescription() {
        return this.participantDescription;
    }

    public void setParticipantDescription(String participantDescription) {
        this.participantDescription = participantDescription;
    }

    public boolean getDisableOtherVideosOnTop() {
        return this.disableOtherVideosOnTop;
    }

    public void setDisableOtherVideosOnTop(boolean disableOtherVideosOnTop) {
        this.disableOtherVideosOnTop = disableOtherVideosOnTop;
    }

    public double getNtpTime() {
        return this.ntpTime;
    }

    public void setNtpTime(double ntpTime) {
        this.ntpTime = ntpTime;
    }

    public String toString() {
        return "RecorderEvent: " + this.getType().toString() + " @" + this.getInstant() + "(" + this.getMediaType() + ")";
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public static enum AspectRatio {
        ASPECT_RATIO_16_9("16_9", 1.7777777777777777),
        ASPECT_RATIO_4_3("4_3", 1.3333333333333333),
        ASPECT_RATIO_UNKNOWN("UNKNOWN", 1.0);

        public double scaleFactor;
        private String stringValue;

        private AspectRatio(String stringValue, double scaleFactor) {
            this.scaleFactor = scaleFactor;
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }

        public static AspectRatio parseString(String str) {
            for (AspectRatio aspectRatio : AspectRatio.values()) {
                if (!aspectRatio.toString().equals(str)) continue;
                return aspectRatio;
            }
            return ASPECT_RATIO_UNKNOWN;
        }
    }

    public static enum Type {
        RECORDING_STARTED("RECORDING_STARTED"),
        RECORDING_ENDED("RECORDING_ENDED"),
        SPEAKER_CHANGED("SPEAKER_CHANGED"),
        STREAM_ADDED("STREAM_ADDED"),
        OTHER("OTHER");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Type parseString(String str) {
            for (Type type : Type.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            return OTHER;
        }
    }
}

