#include <sys/param.h>
#include <sys/event.h>

#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>


int
main(int argc, char **argv)
{
	int kq, n;
	struct kevent event[1];

	if (argc != 2)
		errx(1, "Usage: %s pid", argv[0]);

        kq = kqueue();
        if (kq < 0)
                err(1, "kqueue");

	event[0].ident = atoi(argv[1]);
	event[0].filter = EVFILT_PROC;
	event[0].flags = EV_ADD | EV_ENABLE;
	event[0].fflags = NOTE_EXIT | NOTE_FORK | NOTE_EXEC | NOTE_TRACK;
	n = kevent(kq, event, 1, NULL, 0, NULL);
	if (n < 0)
		err(1, "kevent(1)");

	for (;;) {
		n = kevent(kq, NULL, 0, event, 1, NULL);
		if (n < 0)
			err(1, "kevent(2)");
		printf("PID %5ld ", event[0].ident);
		if (event[0].fflags & NOTE_EXIT)
			printf(" EXIT");
		if (event[0].fflags & NOTE_EXEC)
			printf(" EXEC");
		if (event[0].fflags & NOTE_FORK)
			printf(" FORK");
		if (event[0].fflags & NOTE_CHILD)
			printf(" FORK, parent = %ld", event[0].data);
		printf("\n");
	}
}
