/*
 * This is the header file; include it in programs that use
 * the more secure system call (or the more secure popen call)
 * It also contains error codes and such
 *
 * Author information:
 * Matt Bishop
 * Department of Computer Science
 * University of California at Davis
 * Davis, CA  95616-8562
 * phone (916) 752-8060
 * email bishop@cs.ucdavis.edu
 *
 * This code is placed in the public domain.  I do ask that
 * you keep my name associated with it, that you not represent
 * it as written by you, and that you preserve these comments.
 * This software is provided "as is" and without any guarantees
 * of any sort.
 *
 * Version information:
 * 1.0          May 25, 1994            Matt Bishop
 */
/*
 * forward declarations
 */
#ifdef __STDC__
void le_clobber(void);
int le_set(char *);
int le_unset(char *);
int le_umask(int);
int le_openfd(int);
int le_closefd(int);
int le_euid(int);
int le_egid(int);
int msystem(char *);
FILE *mpopen(char *, char *);
int mpclose(FILE *);
int schild(char *, char *[], char *[], FILE *[], int);
int echild(int);
#else
void le_clobber();
int le_set();
int le_unset();
int le_umask();
int le_openfd();
int le_closefd();
int le_euid();
int le_egid();
int msystem();
FILE *mpopen();
int mpclose();
int schild();
int echild();
#endif

/*
 * define error codes
 */
#define SE_NONE		0		/* no error */
#define	SE_NOMEM	-1		/* no memory */
#define SE_NOPIPE	-2		/* no pipes */
#define SE_NOVAR	-3		/* variable not defined */
#define SE_BADFD	-4		/* invalid file descriptor */

/*
 * default security settings
 */
#ifndef DEF_UMASK
#	define DEF_UMASK	077		/* only owner has privileges */
#endif
#ifndef UID_RESET
#	define UID_RESET	-2		/* reset EUID to RUID */
#endif
#ifndef GID_RESET
#	define GID_RESET	-2		/* reset EGID to RGID */
#endif
#ifndef DEF_PATH
#	define DEF_PATH	"PATH=/bin:/usr/bin:/usr/ucb"  /* default search path */
#endif
#ifndef DEF_SHELL
#	define DEF_SHELL	"SHELL=/bin/sh"	/* default shell */
#endif
#ifndef DEF_IFS
#	define DEF_IFS		"IFS= \t\n"	/* default IFS */
#endif
#ifndef NOSHELL
#	define NOSHELL		"/bin/sh"	/* use this if no shell */
#endif
