/*
 * This is a module to test the le_openfd and le_closefd calls;
 * the tester module doesn't do that too well
 *
 * Usage:
 *	testfd [ file ]
 * Here, file is any file (it will be printed on the screen, so
 * for your sake it should be readable!); if omitted, we use /etc/passwd.
 * The program tells you what's going on; it basically opend that
 * file, marks it as to stay open, and runs a child which reads from
 * that descriptor.  It then marks it as closed and repeats.  You should
 * see the file printed once, with # at the beginning of each line
 * (along with miscellaneous commentary from the program)
 *
 * Author information:
 * Matt Bishop
 * Department of Computer Science
 * University of California at Davis
 * Davis, CA  95616-8562
 * phone (916) 752-8060
 * email bishop@cs.ucdavis.edu
 *
 * This code is placed in the public domain.  I do ask that
 * you keep my name associated with it, that you not represent
 * it as written by you, and that you preserve these comments.
 * This software is provided "as is" and without any guarantees
 * of any sort.
 *
 * Version information:
 * 1.0          May 25, 1994            Matt Bishop
 */
#include <stdio.h>
#include <ctype.h>
#include "env.h"

/*
 * useful globals
 */
char *cmd = "sed 's/^/#/' <&%d";	/* default command */
char *deffile = "/etc/passwd";		/* default file name */

/*
 * error handler
 * just say what happened
 */
void oops(int code)
{
	switch(code){
	case SE_NONE: 			/* no error */
		return;
	case SE_NOMEM: 			/* no memory */
		printf("ran out of memory\n");
		return;
	case SE_NOPIPE: 		/* no pipes */
		printf("can't create another pipe\n");
		return;
	case SE_NOVAR: 			/* no variable */
		printf("unknown environment variable\n");
		return;
	case SE_BADFD:	 		/* no file descriptor */
		printf("unknown file descriptor\n");
		return;
	default:			/* no idea! */
		printf("unknown error %d\n", code);
		return;
	}
}

/*
 * the start of the problem
 */
void main(int argc, char **argv)
{
	int fd;			/* file descriptor to be marked */
	FILE *fp;		/* used to open file */
	char cmdbuf[1024];	/* command buffer */
        FILE *fproc;		/* used for mpopen/mpclose */

	/*
	 * open the relevant file
	 */
	if ((fp = fopen(argc == 1 ? deffile : argv[1], "r")) == NULL){
		perror(argc == 1 ? deffile : argv[1]);
		exit(1);
	}
	if ((fd = fileno(fp)) < 0){
		perror("fileno");
		exit(1);
	}

	/*
	 * now say what you are doing
	 */
	printf("reading from file descriptor %d\n", fileno(fp));
	(void) sprintf(cmdbuf, cmd, fileno(fp));
	printf("This one should print the file %s with leading # ...\n",
						argc == 1 ? deffile : argv[1]);
	/*
	 * mark the file open and feed it to the command
	 */
	oops(le_openfd(fileno(fp)));
	if ((fproc = mpopen(cmdbuf, "w")) == NULL){
		perror(cmdbuf);
		exit(1);
	}
	/*
	 * say what happened
	 */
	printf("status is %d\n", mpclose(fproc));

	/*
	 * again, say what you are doing
	 */
	printf("reading from file descriptor %d\n", fileno(fp));
	printf("This one should print nothing ...\n");

	/*
	 * mark the file open and feed it to the command
	 */
	oops(le_closefd(fd));
	if ((fproc = mpopen(cmdbuf, "w")) == NULL){
		perror(cmdbuf);
		exit(1);
	}
	/*
	 * say what happened
	 */
	printf("status is %d\n", mpclose(fproc));

	/*
	 * say goodnight, Dick!
	 */
	exit(1);
}
