#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <sys/sockio.h>
#include <errno.h>
#include <string.h>

char *
getdefaultif(char *sbuf)
{
     char *interface = "le0";
     struct ifconf ifc;
     struct ifreq *ifr;
     char buf[1024];
     int sock;
     
     if((sock = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
	  perror("socket");
     else {
	  ifc.ifc_len = sizeof(buf);
	  ifc.ifc_buf = buf;

	  if(ioctl(sock, SIOCGIFCONF, (void *)&ifc) == -1)
	       perror("ioctl");
	  else {
	       int i;
	       ifr = ifc.ifc_req;
	       for(i=0;ifr[i].ifr_name;i++){
		    if(strncmp(ifr[i].ifr_name, "lo", 2) != 0){
			 interface = ifr[i].ifr_name;
			 break;
		    }
	       }
	  }
	  close(sock);
     }
     if(sbuf){
	  strcpy(sbuf, interface);
	  return sbuf;
     }
     else {
	  return strdup(interface);
     }
}

#ifdef TEST_VERSION

main()
{
     printf("%s\n", getdefaultif((char *)0));
}

#endif
