/*
     net logger - network traffic logging library
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

timeval.c - 03/20/93

*/
#include <sys/time.h>

#define MICPSEC 1000000

float
microsec(struct timeval tv)
{
     return (float)tv.tv_sec*MICPSEC+tv.tv_usec;
}

struct timeval
subtime(struct timeval t1, struct timeval t2)
{
     struct timeval result;

     result.tv_sec = t1.tv_sec - t2.tv_sec;

     if(t1.tv_usec < t2.tv_usec){
	  result.tv_sec--;
	  result.tv_usec = MICPSEC-t2.tv_usec + t1.tv_usec;
     }
     else
	  result.tv_usec = t1.tv_usec - t2.tv_usec;
     
     return result;
}

struct timeval
addtime(struct timeval t1, struct timeval t2)
{
     struct timeval result;
     
     result.tv_sec = t1.tv_sec + t2.tv_sec;

     if((result.tv_usec = t1.tv_usec + t2.tv_usec) > MICPSEC){
	  result.tv_usec -= MICPSEC;
	  result.tv_sec++;
     }

     return result;
}

char *
gettimestr(struct timeval tp)
{
     struct tm *tm;
     static char buf[50];

     tm = localtime(&tp.tv_sec);

     if(tm->tm_year > 99){
	  sprintf(buf, "%02d/%02d/%04d %02d:%02d:%02d",
		  tm->tm_mon+1,
		  tm->tm_mday,
		  tm->tm_year+1900,
		  tm->tm_hour,
		  tm->tm_min,
		  tm->tm_sec);
     }
     else {
	  sprintf(buf, "%02d/%02d/%02d %02d:%02d:%02d",
		  tm->tm_mon+1,
		  tm->tm_mday,
		  tm->tm_year,
		  tm->tm_hour,
		  tm->tm_min,
		  tm->tm_sec);
     }

     return buf;
}

void
outtime(struct timeval tp)
{
     char *buf;
     buf = gettimestr(tp);
     printf("%s", buf);
}
