/* rfiles.h -- resource file header					*/
/*
 * Copyright (c) 1994  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */
#ifndef	RFILES_H
#define	RFILES_H

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#define	put_string(f, s)	fputs(s, f)

#ifdef	__STDC__
String	write_resource_file(String, XtPointer, Widget, String,
			    XtResourceList, int);
String	write_resource_stream(FILE *, XtPointer, Widget, String,
			      XtResourceList, int);
void	put_resource_line(FILE *, String, String);
Bool	parse_resource_line(String, String *, String *, String *);
String	escape_resource(String);
void	faddc(String *, String *, int *, int *, int);
String	resource_to_string(Widget, XtPointer, XtResource *);
Bool	string_to_resource(Widget, XtPointer, XtResource *, String);
String	string_from_db(XrmDatabase, String, String);
String	read_resource_file(String, XtPointer, Widget, String, String,
			   XtResourceList, int);
String	read_resource_db(XrmDatabase, XtPointer, Widget, String, String,
			 XtResourceList, int);
String	cvt_to_string(Widget, XtPointer, Cardinal, Cardinal, String);
Bool	cvt_from_string(String, Widget, XtPointer, Cardinal, Cardinal,
			String, Bool);
int	escape(String *);
String	quoted_string(String *, int);
#else	/* __STDC__ */
String	write_resource_file();
String	write_resource_stream();
void	put_resource_line();
Bool	parse_resource_line();
String	escape_resource();
void	faddc();
String	resource_to_string();
Bool	string_to_resource();
String	string_from_db();
String	read_resource_file();
String	read_resource_db();
String	cvt_to_string();
Bool	cvt_from_string();
int	escape();
String	quoted_string();
#endif	/* __STDC__ */

/* append a char to a line, allocating new space if necessary
 *
 * Arguments are:
 *	l -- points to beginning of line buffer
 *	s -- points to char after current end of line
 *	len -- current length of line: should be s - l.
 *	n -- current size of line buffer
 *	c -- char to append
 */
#define	addc(l, s, len, n, c)\
(									\
    (len++ < n) ? (*s++ = c) : (len--, faddc(&l, &s, &len, &n, c))	\
)

#endif	/* RFILES_H */
