/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

#include <X11/Intrinsic.h>
#include <ctype.h>
#include <stdio.h>
#include "wlintP.h"

void CapitalizationTest ( Widget shell, ActionType action )
{
    char *name, *appClass;

    if( action == INIT ||
        action == POSTOP )
        return;

    if(!XtIsShell(shell))
	return;    

    XtGetApplicationNameAndClass ( XtDisplay(shell),
                                   &name, &appClass );

    if ( name && appClass && strlen ( name ) > 2 )
    {
        if ( name [0]     == 'x' &&
	             appClass[0] != 'X' && 
             name[1]     != tolower ( appClass[1] ) )
        { 
            fprintf(stderr, 
                    "Unconventional Application class name\n");
            fprintf(stderr, "Classname should be ");
            if(strlen(name) > 2)
                fprintf(stderr, "X%c%s\n",
                                 toupper(name[1]),
                                 &name[2]);
            else
                fprintf(stderr, "X%c",
                                 toupper(name[1]));
        }
        else if (name [0] != tolower(appClass[0]))
        {
            fprintf(stderr, 
                    "Unconventional Application class name\n");
            fprintf(stderr, "Classname should be ");
            fprintf(stderr, "%c%s\n",
                            toupper(name[0]), 
                            &name[1]);
        }
    }
}
