/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**********************************
 * classnametest.c
 **********************************/
#include <X11/Intrinsic.h>
#include <ctype.h>
#include <stdio.h>
#include "wlintP.h"

void ClassNameTest ( Widget shell, ActionType action )
{
    char *name, *appClass;

    if ( action == INIT ||
         action == POSTOP )
        return;

    if ( !XtIsShell ( shell ) )
       	return;    

   /*
    * Retrieve the name and class name of the application
    */

    XtGetApplicationNameAndClass ( XtDisplay ( shell ),
                                   &name, &appClass );
   /*
    * Compare the names and class names. By convention, these
    * should nominally be the same, except for case, unlass
    * a user changes the name of the executable.
    */

    if ( name && appClass )
    {
        if ( strcasecmp ( name, appClass ) )
        {
            fprintf ( stderr, 
                 "Application name/class name mismatch:");
            fprintf ( stderr, 
                      "name = %s class = %s\n", 
                      name, appClass );
        }
    }
}

