/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**************************************************
 * CountWidgets.c: Count the widgets in a program.
 **************************************************/
#include <Xm/Xm.h>
#include <stdio.h>
#include "wlintP.h"

static int numManagers;
static int numPrimitive;
static int numGadgets;
static int numShells;
static int total;

void CountWidgets ( Widget w, ActionType action )
{
    Cardinal numChildren;
    WidgetList children;

    if ( action == INIT )
    {
        numManagers  = 0;
        numPrimitive = 0;
        numGadgets   = 0;
        total        = 0;
        numShells    = 0;
        return;
    }

    if ( action == POSTOP )
    {
        printf ( "Total number of widgets = %d\n", total);
        printf ( "Total number of manager widgets = %d\n",
                 numManagers );
        printf ( "Total number of shells = %d\n", 
                 numShells );
        printf ( "Total number of primitive widgets = %d\n",
                 numPrimitive );
        printf ( "Total number of gadgets = %d\n", 
                 numGadgets );
        return;
    }

    if ( XmIsGadget ( w ) )
        numGadgets++;
    else if ( XmIsManager ( w ) )
        numManagers++;
    else if ( XmIsPrimitive ( w ) )
        numPrimitive++;
    else if ( XtIsShell ( w ) )
        numShells++;    
    total++;
}

