/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**************************************************
 * ReportDepth.c: Report the depth of deepest part
 *                of the widget hierarchy.
 **************************************************/
#include <Xm/Xm.h>
#include <stdio.h>
#include "wlintP.h"

static int depth;

void ReportDepth ( Widget w, ActionType action )
{
    int count;

    if ( action == INIT )
    { 
        depth = 0;
        return;
    }

    if ( action == POSTOP )
    {
        fprintf ( stderr,"Greatest widget tree depth = %d\n",
                  depth );
        return;
    }

    count = 1;
    
    while ( w = XtParent ( w ) )
        count++;

    if ( count > depth )
        depth = count;
}

