/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************
 *
 ********************************************/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <stdio.h>
#include "wlintP.h"

void TESTATTACHMENT(Widget w, int fractionBase, unsigned char side, char * sideName, int position)
{
    if ( side  == XmATTACH_POSITION && 
         position > fractionBase )     
        fprintf ( stderr,              
                  "%s position is too large: %s\n",
                  sideName,                        
		  XtName ( w ) );
}


void FormAttachments ( Widget w, ActionType action )
{
    unsigned char top, bottom, left, right;
    int           topPosition, bottomPosition, 
                  leftPosition, rightPosition;
    int           fractionBase;
    Widget        topWidget, bottomWidget,
                  leftWidget, rightWidget;

    if( action == INIT ||
        action == POSTOP )
        return;

    if ( !XtParent ( w ))
        return;

    if ( !XmIsForm ( XtParent ( w ) ) )
        return;

    XtVaGetValues ( XtParent ( w ),
                    XmNfractionBase, &fractionBase,
                    NULL );
  
    XtVaGetValues ( w,
                    XmNleftAttachment,   &left,
                    XmNrightAttachment,  &right,
                    XmNtopAttachment,    &top,
                    XmNbottomAttachment, &bottom,
                    XmNtopPosition,      &topPosition,
                    XmNbottomPosition,   &bottomPosition,
                    XmNleftPosition,     &leftPosition,
                    XmNrightPosition,    &rightPosition,
                    XmNtopWidget,        &topWidget,
                    XmNbottomWidget,     &bottomWidget,
                    XmNleftWidget,       &leftWidget,
                    XmNrightWidget,      &rightWidget, 
                    NULL );

   /*
    * Check position attachments
    */

    TESTATTACHMENT ( w, fractionBase, left, "left", leftPosition);
    TESTATTACHMENT ( w, fractionBase, right, "right", rightPosition);
    TESTATTACHMENT ( w, fractionBase, top, "top", topPosition);
    TESTATTACHMENT ( w, fractionBase, bottom, "bottom", bottomPosition);

    if ( left  == XmATTACH_POSITION && 
         right == XmATTACH_POSITION &&
         leftPosition >= rightPosition)
        fprintf ( stderr, 
                  "invalid left/right positions: %s\n",
                  XtName(w));

    if ( top    == XmATTACH_POSITION &&
         bottom == XmATTACH_POSITION &&
         bottomPosition <= topPosition)
       fprintf ( stderr, 
                 "Invalid top/bottom positions: %s\n",
                 XtName(  w ) );

   /*
    * Test each widget attachment
    */

#define TEST(side,sideName,widget,otherside)                 \
    if ( side == XmATTACH_WIDGET)                            \
    {                                                        \
        unsigned char attach;                                \
        if ( widget == NULL )                                \
            fprintf ( stderr,                                \
                      "%s has a NULL %s widget\n",                \
                      XtName ( w ), sideName );              \
        else                                                 \
        {                                                    \
            XtVaGetValues ( widget,                          \
                            otherside,&attach,               \
                            NULL );                          \
            if ( attach != XmATTACH_NONE )                   \
                fprintf ( stderr,                            \
                          "%s is attached on the %s to %s\
whose %s resource is not set to attach_none\n", \
                     XtName ( w ), sideName,                    \
			   XtName ( widget ), otherside );      \
        }                                                    \
    }                                                 

    TEST ( top,    "top",   topWidget,    XmNbottomAttachment )
    TEST ( bottom, "bottom",bottomWidget, XmNtopAttachment )
    TEST ( left,   "left",  leftWidget,   XmNrightAttachment )
    TEST ( right,  "right", rightWidget,  XmNleftAttachment )

#define OPPOSITETEST(side,sideName,widget)            \
    if ( side == XmATTACH_OPPOSITE_WIDGET)            \
    {                                                 \
        unsigned char attach;                         \
        if ( widget == NULL )                         \
            fprintf ( stderr,                         \
                      "NULL %s widget: %s\n",         \
                      sideName, XtName ( w ) );       \
    }

    OPPOSITETEST ( top,    "top",    topWidget )
    OPPOSITETEST ( bottom, "bottom", bottomWidget )
    OPPOSITETEST ( left,   "left",   leftWidget )
    OPPOSITETEST ( right,  "right",  rightWidget )
}


