/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*******************************************************
 * GeometryResourceTest.c: Test for geometry resources
 *                          in resource files.
 *******************************************************/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <stdio.h>
#include "wlintP.h"

extern XtPointer GetResourceFromDatabase ( Widget w, 
					   const  char *, 
					   const  char *, 
					   const  char *, 
					   int );

void GeometryResourceTest ( Widget w, ActionType action )
{
    unsigned char top, bottom, left, right, dbattachment;
    int           topPosition, bottomPosition, 
                  leftPosition, rightPosition, dbposition;
    Widget        topWidget, bottomWidget,
                  leftWidget, rightWidget, dbwidget;
    Position      x, y, dbpos;
    Dimension     width, height, dbsize;

    if( action == INIT ||
        action == POSTOP )
        return;

    if ( !XtParent ( w ) )
        return;

    XtVaGetValues ( w,
                    XmNx,                &x,
                    	XmNy,                &y,
                    XmNwidth,            &width,
                    XmNheight,           &height,
                    XmNleftAttachment,   &left,
                    XmNrightAttachment,  &right,
                    XmNtopAttachment,    &top,
                    XmNbottomAttachment, &bottom,
                    XmNtopPosition,      &topPosition,
                    XmNbottomPosition,   &bottomPosition,
                    XmNleftPosition,     &leftPosition,
                    XmNrightPosition,    &rightPosition,
                    XmNtopWidget,        &topWidget,
                    XmNbottomWidget,     &bottomWidget,
                    XmNleftWidget,       &leftWidget,
                    XmNrightWidget,      &rightWidget, 
                    NULL );

#define POSTEST(value, resname, resclass, restype, size)      \
   dbpos =                                                    \
       (Position) GetResourceFromDatabase ( w,                \
                                            resname, resclass,\
                                            restype, size );  \
    if ( value == dbpos && value != 0 )                       \
        fprintf ( stderr,                                     \
                  "%s's XmN%s resource *may* come from file\n",    \
                  XtName ( w ), resname );

POSTEST(x, XmNx, XmCPosition, XmRPosition, sizeof ( Position ) )
POSTEST(y, XmNy, XmCPosition, XmRPosition, sizeof (Position ) )

#define SIZETEST(value, resname, resclass, restype)           \
   dbsize =                                                   \
      (Dimension) GetResourceFromDatabase ( w,                \
                                            resname, resclass,\
                                            restype,          \
                                      sizeof ( Dimension ) ); \
    if ( value == dbsize && value != 0 )                      \
        fprintf ( stderr,                                     \
                  "%s's XmN%s resource *may* come from file\n",    \
                  XtName(w), resname );

SIZETEST(width, XmNwidth, XmCDimension,  XmRDimension )
SIZETEST(height, XmNheight, XmCDimension,  XmRDimension)

    if ( XmIsForm ( XtParent ( w ) ) )
    {
#define ATTACHMENTTEST(value, attachment)                     \
        dbattachment =                                        \
              (unsigned char) GetResourceFromDatabase ( w,    \
                                    attachment,               \
                                    XmCAttachment,            \
                                    XmRAttachment,            \
                                    sizeof(unsigned char) );  \
       if ( dbattachment == value && value != 0 ) \
            fprintf ( stderr,                                 \
                  "%s's XmN%s resource *may* come from file\n",    \
                  XtName(w), attachment);
	
ATTACHMENTTEST(left,   XmNleftAttachment)     
ATTACHMENTTEST(right,  XmNrightAttachment)     
ATTACHMENTTEST(top,    XmNtopAttachment)     
ATTACHMENTTEST(bottom, XmNbottomAttachment)     

#define POSITIONTEST(value, position)                       \
        dbposition =                                        \
              (int) GetResourceFromDatabase ( w,    \
                                    position,             \
                                    XmCAttachment,           \
                                    XmRAttachment,           \
                                    sizeof(int) );  \
       if ( dbposition == value && value != 0)                           \
            fprintf ( stderr,                                 \
                  "XmN%s resource *may* come from file %s\n",    \
                  position, XtName ( w ) ); 
POSITIONTEST(leftPosition,   XmNleftPosition)     
POSITIONTEST(rightPosition,  XmNrightPosition)     
POSITIONTEST(topPosition,    XmNtopPosition)     
POSITIONTEST(bottomPosition, XmNbottomPosition)     

#define WIDGETTEST(value, attachment)                         \
        dbwidget =                                        \
              (Widget) GetResourceFromDatabase ( w,    \
                                    attachment,              \
                                    XmCAttachment,            \
                                    XmRAttachment,            \
                                    sizeof(Widget) );  \
       if ( dbwidget == value && value != 0)                           \
            fprintf ( stderr,                                 \
                  "XmN%s resource *may* come from file %s\n",    \
                  attachment, XtName ( w ) );

WIDGETTEST(leftWidget,   XmNleftWidget)     
WIDGETTEST(rightWidget,  XmNrightWidget)     
WIDGETTEST(topWidget,    XmNtopWidget)     
WIDGETTEST(bottomWidget, XmNbottomWidget)     
 
     }
}


