/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/***********************************************************
 * GetResourceFromDatabase.c: Retrieve a resource relative
 *                            to a widget.
 **********************************************************/
#include <Xm/Xm.h>
#include <assert.h>
#include <Vk/XtHacks.h>


XtPointer GetResourceFromDatabase ( Widget w, 
	                                const  char *name, 
	                                const  char *className,
	                                const  char *desiredType,
                               int    size )
{
    static XtPointer returnValue = NULL;
    XtResource requestResources;

    assert ( size <= sizeof ( XtPointer ) );
    assert ( w );

   /*
    * Fill out the resource structure.
    */

    requestResources.resource_name   = ( char* ) name;
    requestResources.resource_class  = ( char* ) className;
    requestResources.resource_type   = ( char*) desiredType;
    requestResources.resource_size   = size;
    requestResources.default_type    = XmRImmediate;
    requestResources.resource_offset = 0;
    requestResources.default_addr    = ( XtPointer ) NULL;

   /*
    * Retrieve the value relative to the given widget.
    */

    XtGetSubresources(  w, 
		                       ( XtPointer ) &returnValue, 
		                       NULL, NULL, &requestResources,
		                       1, NULL, 0 );
   /*
    * Different sizes require different treatment.
    */

    if ( !strcmp ( desiredType, XmRString ) )
        return ( returnValue );
    else if ( size == sizeof ( long ) )
        return ( ( XtPointer ) *( long* ) &returnValue );
    else if ( size == sizeof( short ) )
        return ( ( XtPointer ) *( short* ) &returnValue );
    else if (size == sizeof ( char ) )
        return (( XtPointer ) *( char* ) &returnValue );
    else if ( size == sizeof ( XtArgVal ) )
        return ( *( XtPointer* ) &returnValue );

    return ( returnValue );
}

