/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************************
 * nullclassname.c: Check for a NULL application class name.
 ************************************************************/
#include <X11/Intrinsic.h>
#include <ctype.h>
#include <stdio.h>
#include "wlintP.h"

void NULLClassNameTest ( Widget shell, ActionType action )
{
    char *name, *appClass;

    if( action == INIT ||
        action == POSTOP )
        return;

    if ( !XtIsShell ( shell ) )
       	return;    

   /*
    * Retrieve the name and class name from the shell
    * and see if it is non-NULL.
    */

    XtGetApplicationNameAndClass ( XtDisplay ( shell ),
                                   &name, &appClass );

    if(!appClass)
    {
        fprintf ( stderr, 
                 "Application has a NULL class name\n" );
    }
}

