/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**********************************************************
 * realize.c: XtRealizeWidget wrapper to automatically
 *            run WL tests. WARNING: Assumes SVR4 shared
 *            library support.
 **********************************************************/
#ifndef NDEBUG
#include <dlfcn.h>
#include <assert.h>
#include <Xm/Display.h>
#include "wlint.h"

/*
 * Declare a function type so we can cast.
 */

typedef void ( *realize )( Widget );

void XtRealizeWidget ( Widget 	  shell )
{
    void   *handle;
    realize fptr;
    
   /*
    * Load the real Xt.
    */

    handle = dlopen ( "/usr/lib/libXt.so", RTLD_LAZY );
    assert ( handle );

   /* 
    * Find the address of XtRealizeWidget in the Xt library.
    */

    	fptr = ( realize ) dlsym ( handle, "XtRealizeWidget" );

    assert ( fptr );

   /*
    * Call the real XtRealizeWidget function.
    */

    	( *fptr )( shell );

   /*
    * Invoke the WL test functions.
    */

    WLRunTests ( shell, "After Realization" );    
}
#endif

