/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/****************************************
 * RedundantManagerTest.c
 ****************************************/
#include <Xm/Xm.h>
#include <Xm/Frame.h>
#include <stdio.h>
#include "wlintP.h"

void RedundantManagerTest ( Widget w, ActionType action )
{
    if ( action == INIT || action == POSTOP )
        return;

    if ( XmIsManager ( w ) && !XmIsFrame ( w ) )
    {
        Cardinal numChildren;
        WidgetList children;

        XtVaGetValues ( w,
                        XmNnumChildren, &numChildren,
                        XmNchildren, &children,
                        NULL );

        if ( numChildren == 1 && XmIsManager ( children[0] ) )
            printf( "%s manages only %s, which is a manager\n",
                    XtName ( w ), XtName ( children[0] ) );
    }
}

