/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

#include "wlintP.h"
extern void ValidWidgetTest(Widget, ActionType);
extern void UnmanagedTest(Widget, ActionType);
extern void ClassNameTest(Widget , ActionType);
extern void ShortNameTest(Widget , ActionType);
extern void CapitalizationTest(Widget, ActionType);
extern void ScrolledTest(Widget, ActionType);

extern void FormAttachments(Widget, ActionType);

extern void GeometryResourceTest(Widget, ActionType);

extern void NULLClassNameTest(Widget, ActionType);

extern void ShadowClobberTest(Widget, ActionType);
extern void CountWidgets(Widget, ActionType);
extern void ReportDepth(Widget, ActionType);

void WLRegisterTests ( void )
{
   /* Add new tests here by calling WLAddTest() */

    WLAddTest ( "Testing for in-valid and destroyed widgets ",
		ALL, ValidWidgetTest );
    
    WLAddTest("Unmanaged Widget Check ",
            ALL, UnmanagedTest);
    
    WLAddTest("Name/class name mismatch",
            JUSTONCE, ClassNameTest);
    
    WLAddTest("Looking for short application names",
            JUSTONCE, ShortNameTest);
    
    WLAddTest("Checking classname conventions",
            JUSTONCE, CapitalizationTest );

    WLAddTest("Checking Form Attachments",
	      ALL, FormAttachments);

    WLAddTest("Checking Geometry resources",
	      ALL, GeometryResourceTest );

    WLAddTest("NULL Class name test",
	      JUSTONCE, NULLClassNameTest );

    WLAddTest("Shadow Test",
	      ALL,  ShadowClobberTest );

    WLAddTest("Scrolled Window Test",
	      ALL,  ScrolledTest );

    WLAddTest("Count Widgets Test",
	      ALL,  CountWidgets );

    WLAddTest("Dpeth Test",
	      ALL,  ReportDepth );            
    
}

