/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*******************************************************
 * GeometryResourceTest.c: Test for geometry resources
 *                          in resource files.
 *******************************************************/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <stdio.h>
#include "wlintP.h"

extern XtPointer GetResourceFromDatabase ( Widget w, 
			                                           const  char *, 
			                                           const  char *, 
			                                           const  char *, 
                                           			int );
static void PositionTest ( Widget w,
                           int    value, 
                           char  *resname )
{
   Position pos;

  /*
   * See if the retrieved position resource matches the
   * widgets current value. Ignore values of zero.
   */

   pos =  ( Position ) GetResourceFromDatabase ( w,         
                                        resname,
                                        XmCPosition,
                                        XmRPosition, 
                                        sizeof( Position ) );
    if ( value == pos && pos != 0 )     
        fprintf ( stderr,                                    
                  "%ss XmN%s resource *may* come from file\n",
                  XtName ( w ) , resname );
}

static void SizeTest ( Widget    w,
                       Dimension value,
                       char     *resname )
{    
    Dimension size;

  /*
   * See if the retrieved dimension resource matches the
   * widgets current value. 
   */

    size = ( Dimension ) GetResourceFromDatabase ( w, 
                                 resname, XmCDimension,
                                 XmRDimension,  
                                 sizeof ( Dimension ) );
    if ( value == size )                                  
        fprintf ( stderr,                                   
               "%ss XmN%s resource *may* come from file\n",
               XtName ( w ), resname );
}


static void AttachmentTest ( Widget        w, 
                             unsigned char value,
                             char         *attachment ) 
{
    unsigned char dbvalue;

   /*
    * Check the form attachment resource
    */

    dbvalue = 
          ( unsigned char ) GetResourceFromDatabase ( w,
                                  attachment,  XmCAttachment,
                                  XmRInt,
                                  sizeof ( unsigned char ) );
       if ( dbvalue == value )       
            fprintf ( stderr,                              
                  "%ss XmN%s resource *may* come from file\n", 
                  XtName ( w ), attachment ); 
}

static void  PositionAttachmentTest ( Widget w,
                                      int    value, 
                                      char  *attachment) 
{    
  /*
   * See if the retrieved position attachment matches the
   * widgets current value. 
   */
            
  int position = ( int ) GetResourceFromDatabase ( w, 
                                             attachment,
                                             XmCAttachment,
                                             XmRInt,
                                             sizeof ( int ) );
   if ( position == value )         
      fprintf ( stderr,                
                "%ss XmN%s resource *may* come from file\n",
                XtName ( w ), attachment ); 
}

/*
 * WL test function
 */

void GeometryResourceTest ( Widget w, ActionType action )
{
    unsigned char top, bottom, left, right, dbattachment;
    int           topPosition, bottomPosition, 
                  leftPosition, rightPosition, dbposition;
    Widget        topWidget, bottomWidget,
                  leftWidget, rightWidget, dbwidget;
    Position      x, y, dbpos;
    Dimension     width, height, dbsize;

    if( action == INIT ||
        action == POSTOP )
        return;

    if ( !XtParent ( w ) )
        return;
   /*
    * Retrieve all positional resources.
    */

    XtVaGetValues ( w,
                    XmNx,                &x,
                    	XmNy,                &y,
                    XmNwidth,            &width,
                    XmNheight,           &height,
                    XmNleftAttachment,   &left,
                    XmNrightAttachment,  &right,
                    XmNtopAttachment,    &top,
                    XmNbottomAttachment, &bottom,
                    XmNtopPosition,      &topPosition,
                    XmNbottomPosition,   &bottomPosition,
                    XmNleftPosition,     &leftPosition,
                    XmNrightPosition,    &rightPosition,
                    XmNtopWidget,        &topWidget,
                    XmNbottomWidget,     &bottomWidget,
                    XmNleftWidget,       &leftWidget,
                    XmNrightWidget,      &rightWidget, 
                    NULL );

   /*
    * Test each widgets x,y,width and height resources.
    */

    PositionTest ( w, x, XmNx );
    PositionTest ( w, y, XmNy );
    SizeTest ( w, width, XmNwidth );
    SizeTest ( w, height, XmNheight );
   
   /*
    * If the parent is a form widget, 
    * test attachment resources
    */

    if ( XmIsForm ( XtParent ( w ) ) )
    {
        AttachmentTest ( w, left,  XmNleftAttachment );
        AttachmentTest ( w, right, XmNrightAttachment );
        AttachmentTest ( w, top,   XmNtopAttachment ); 
        AttachmentTest ( w, bottom,XmNbottomAttachment );
 
        if ( left == XmATTACH_POSITION )
            PositionAttachmentTest ( w, leftPosition, 
                                     XmNleftPosition );
        if ( right == XmATTACH_POSITION )
            PositionAttachmentTest ( w, rightPosition,
                                     XmNrightPosition );
        if ( top == XmATTACH_POSITION )
            PositionAttachmentTest ( w, topPosition,
                                     XmNtopPosition );
        if ( bottom == XmATTACH_POSITION )
            PositionAttachmentTest ( w, bottomPosition,
                                     XmNbottomPosition );
    }
}

