/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************
 *
 ********************************************/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <stdio.h>
#include "wlintP.h"

void ScrolledTest ( Widget w, ActionType action )
{
    Dimension formwidth, formheight, width, height;
    unsigned char top, bottom, left, right;
    int           topOffset, bottomOffset, 
                  leftOffset, rightOffset;
    int x;

    if( action == INIT ||
        action == POSTOP )
        return;

    if ( !XtParent ( w ))
        return;

    if ( !(XmIsForm ( XtParent ( w )) && XmIsScrolledWindow ( w ) ))
        return;

    XtVaGetValues ( XtParent ( w ),
		    XmNwidth,  &formwidth,
		    XmNheight, &formheight,		    
                    NULL );

    XtVaGetValues ( w,
                    XmNleftAttachment,   &left,
                    XmNrightAttachment,  &right,
                    XmNtopAttachment,    &top,
                    XmNbottomAttachment, &bottom,
                    XmNtopOffset,      &topOffset,
                    XmNbottomOffset,   &bottomOffset,
                    XmNleftOffset,     &leftOffset,
                    XmNrightOffset,    &rightOffset,
                    XmNwidth,    &width,
                    XmNheight,    &height,		    		    
                    NULL );

    if(topOffset    == 0 &&
       bottomOffset == 0 &&
       leftOffset   == 0 &&
       rightOffset  == 0 &&
       left         == XmATTACH_FORM &&
       top          == XmATTACH_FORM &&
       bottom       == XmATTACH_NONE &&
       right        == XmATTACH_NONE)
    {
	fprintf(stderr, "Attachments *may* have been placed on form grandchild\n");
	fprintf(stderr, "Form = %s scrolled window = %s\n",
		XtName(XtParent (w)), XtName (w));
    }
}
