/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************
 * ShadowClobbertest.c
 ********************************************/
#include <Xm/Xm.h>
#include <stdio.h>
#include "wlintP.h"

void ShadowClobberTest ( Widget w, ActionType action )
{
    Widget    parent;
    Position  x, y;
    Dimension width, height, pwidth, pheight;
    Dimension shadow;

    if( action == INIT ||
        action == POSTOP )
        return;
   /*
    * Make sure this widget has a managed Motif manager
    * widget as a parent. Shells can have a Motif manager
    * as a parent, but they are not interesting because
    * a shell can only be a popup child, which would not
    * cover any shadows.
    */

    if ( ( parent = XtParent ( w ) ) == NULL )
        return;

    if ( !XmIsManager ( parent ) || XtIsShell ( w ) )
	        return;

    if ( !XtIsManaged ( w ) || !XtIsManaged ( parent ) )
        return;

   /*
    * Get the dimensions of parent and child.
    */

    XtVaGetValues ( w, 
                    XmNx, &x,  XmNy, &y,
                    XmNwidth,  &width,
                    XmNheight, &height,
                    NULL );
    XtVaGetValues ( parent, 
                    XmNwidth,           &pwidth,
                    XmNheight,          &pheight,
                    XmNshadowThickness, &shadow,
                    NULL );
   /*
    * If the parent has a shadow, see if the child 
    * covers any part of it.
    */

    if ( shadow == 0 )
        return;

    if ( x < shadow || y < shadow ||
         x + width  > pwidth - shadow ||
         y + height > pheight - shadow )
    {
        fprintf ( stderr, "%s covers shadow of parent %s\n",
                          XtName ( w ), XtName ( parent ) );
    }
}

