/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************
 *
 ********************************************/
#include <X11/IntrinsicP.h>
#include <Xm/Xm.h>
#include <stdio.h>
#include "wlintP.h"

void ShadowClobberTest ( Widget w, ActionType action )
{
    Widget parent;
    Position x, y;
    Dimension width, height, pwidth, pheight;
    Dimension shadow;

    if( action == INIT ||
        action == POSTOP )
        return;

    if ( ( parent = XtParent ( w ) ) == NULL )
        return;

    if(!XmIsManager(parent) && !XtIsShell(w))
	return;

    XtVaGetValues ( w, 
                    XmNx, &x,  XmNy, &y,
                    XmNwidth,  &width,
                    XmNheight, &height,
                    NULL );
    XtVaGetValues ( parent, 
                    XmNwidth,           &pwidth,
                    XmNheight,          &pheight,
                    XmNshadowThickness, &shadow,
                    NULL );

    if ( shadow == 0 )
        return;

    if ( x < shadow || y < shadow ||
         x + width  > pwidth - shadow ||
         y + height > pheight - shadow )
    {
        fprintf ( stderr, "%s covers shadow of parent %s\n",
                          XtName ( w ), XtName ( parent ) );
    }
}


