/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/******************************************************
 * ValidWidgetTest.c: Test integrity of each widget.
 ******************************************************/
#include <X11/IntrinsicP.h>
#include <stdio.h>
#include <stdlib.h>
#include "wlintP.h"

static Widget lastWidget;

void ValidWidgetTest ( Widget w, ActionType action )
{
    if ( action == INIT ||
        action == POSTOP )
    {
        lastWidget = NULL;
        return;
    }

    if ( !XtIsObject ( w ) ) /* Is widget trashed? */
    {
        fprintf ( stderr, "Non object in widget hiearchy\n" );
	if(lastWidget)
	  fprintf ( stderr, "last valid widget = %s\n",
		    XtName ( lastWidget ) );
        abort();
    }
    else if ( w->core.being_destroyed )
        fprintf ( stderr, "%s is being destroyed\n",
                          XtName ( w ) );
    lastWidget = w;
}

