/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/******************************************************
 * wlintP.h: Declarations for use inside WL library
 *           and related test functions.
 *****************************************************/
#include <X11/Intrinsic.h>

typedef enum { SHELL,     /* Test only shells */
               MANAGER,   /* test only managers */
               PRIMITIVE, /* test primitives and gadgets */ 
               GADGET,    /* Test only gadgets */
               ALL,       /* test all widget types */
               JUSTONCE   /* Dont traverse widget tree */
              } TestType;

typedef enum { INIT, RUNTEST, POSTOP } ActionType;

typedef void ( *WLTestProc )( Widget, ActionType );

typedef struct {
    char      *name;  /* Name of the test */
    TestType   type;  /* Widget types to be tested */   
    WLTestProc func;  /* Test function to be executed */
} TestData;

/* 
 * Convenience function for adding tests to  
 * internal TestData array.
 */

extern void WLAddTest ( char      *name,
                        TestType   type,
                        WLTestProc func );

