/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/******************************************
 * CreateWidgetWrapper.c:
 ******************************************/
#ifndef NDEBUG
#include <dlfcn.h>
#include <assert.h>
#include <X11/Intrinsic.h>
#include <ctype.h>

/* 
 * Typedef needed to cast return value of dlsym(). Type
 * declaration is taken from Intrinsic.h.
 */

typedef Widget ( *createfunc ) ( _Xconst _XtString,
                                 WidgetClass,
                                 Widget,
                                 ArgList,
                                 Cardinal );
/*
 * If linking is handled correctly, this function
 * will be called instead of the real XtCreateWidget.
 */

Widget XtCreateWidget ( _Xconst _XtString name,
                        WidgetClass       widgetclass,
                        Widget            parent,
                        ArgList           args,
                        Cardinal          numArgs )
{
    Widget     w;
    void      *handle;
    createfunc fptr;
    int        i;

   /*
    * Xt seems to accept NULL names, but it is a bad idea
    * because resources cannot be retrieved properly.
    */

    assert ( name && *name );

   /*
    * Make sure the parent is legitimate.
    */

    assert ( XtIsObject( parent ) && XtIsComposite ( parent ) );

    for ( i = 0; i < numArgs; i++ )
    {
       /*
        * Check each argument for a NULL name.
        * Theres no way to check for good values, because
        * all values could be valid. This test tries to 
        * confirm that numArgs is less than or equal to 
        * the number of non-NULL resources in the arglist.
        * Put this statement inside braces so it will compile
        * with or without NDEBUG defined. 
        */

        assert ( args && args[i].name && 
                 isascii ( args[i].name[0] ) );
    }

   /* 
    * Load the Xt library. Note that location may
    * vary from system to system.
    */

    handle = dlopen ( "/usr/lib/libXt.so", RTLD_LAZY );
    assert ( handle );

   /* 
    * Get a pointer to XtCreateWidget, in the newly 
    * loaded library.
    */

    fptr = ( createfunc ) dlsym ( handle, "XtCreateWidget" );
    assert ( fptr );
   /* 
    * Call the real Xt function.
    */
    
    w =  (*fptr)( name, widgetclass, parent, args, numArgs );

   /*
    * Check the return value.
    */

    assert ( w && XtIsObject ( w ) );
    return ( w );
}
#endif

