/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/******************************************************
 * Destroy.c: Debugging wrapper for XtDestroyWidget()
 ******************************************************/
#ifndef NDEBUG
#include <dlfcn.h>
#include <assert.h>
#include <X11/IntrinsicP.h>

typedef void ( *destroyfunc )( Widget );

void XtDestroyWidget ( Widget w )
{
    void       *handle = NULL;
    destroyfunc fptr = NULL;

   /*
    * Signal an error if the pointer passed in is not
    * a valid, un-destroyed widget.
    */

    assert ( w );
    assert ( XtIsObject ( w ) );
    assert ( !w->core.being_destroyed );    

   /*
    * Load the real Xt library
    */

    handle = dlopen ( "/usr/lib/libXt.so", RTLD_LAZY );
    assert ( handle );

   /*
    * Get a pointer to the real XtDestroyWidget() function
    */

    fptr = ( destroyfunc ) dlsym(handle, "XtDestroyWidget" );
    assert ( fptr );

   /*
    * Invoke Xts XtDestroyWidget() to destroy the widget
    */

    (*fptr)( w );
}
#endif

