/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************
 * xlogobug.c: A buggy program
 ************************************************/
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

void main ( int argc, char **argv )
{
    Widget       shell, canvas; 
    XtAppContext app; 
    int          width, height;
    XGCValues    values;
    GC           gc;

   /*
    * Initialize Xt and create a shell widget.
    */

    shell = XtAppInitialize ( &app, "Xlogobug", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

   /*
    * Create a drawing area widget in which to display
    * a pair of lines that form an X.
    */

    canvas = 
         XtCreateManagedWidget ( "canvas", 
                                     xmDrawingAreaWidgetClass,
                                 shell, NULL, 0 );

   /*
    * Realize all widgets so the drawing area widgets
    * window will exist and be displayed on the screen.
    */

    XtRealizeWidget ( shell );
   
   /*
    * Determine how large the canvas widget is to allow
    * the lines to be drawn. Also get the widgets foreground 
    * color to use when creating a graphics context,  
    * which is needed to draw the lines.
    */

    XtVaGetValues ( canvas,
                    XmNwidth,      &width,
                    XmNheight,     &height,
                    XmNforeground, &values.foreground,
                    NULL );

   /*
    * Create a GC using the widgets foreground color.
    */

    gc = XtGetGC ( canvas, GCForeground, &values );

   /*
    * Draw an X into the canvas widgets window, using the
    * widgets size to draw a line diagonally between 
    * each corner.
    */
    XDrawLine ( XtDisplay ( canvas ), XtWindow ( canvas ),
                gc, 0, 0, width, height );  

    XDrawLine ( XtDisplay ( canvas ), XtWindow ( canvas ),
                gc, width, 0, 0, height );  

   /*
    * Start handling events.
    */

    XtAppMainLoop ( app );
}


