/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************
 * hello.c: Display"hello world" on the screen.
 *************************************************/
#include <Xm/Xm.h>         
#include <Xm/Label.h> 
#include "TimerTools.h"

 void main ( int argc, char **argv )
{
    Widget       shell, label;
    XtAppContext app;  
    XmString     xmstr;   

    ReportTime ( "Starting", FALSE );

    shell = XtAppInitialize ( &app, "Hello", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    /* Create a string in the form expected by Motif. */

    xmstr = XmStringCreateLtoR ( "Hello World", 
                                 XmFONTLIST_DEFAULT_TAG );

   /*
    * Create a Motif XmLabel widget to display the string.
    */

    label = XtVaCreateManagedWidget ( "label", 
                                     xmLabelWidgetClass, shell,
                                     XmNlabelString, xmstr,
                                     NULL );

    XmStringFree ( xmstr );  /* Free the compound string. */

    XtRealizeWidget ( shell );

    WaitForWindow ( shell );
    HandleEvents ( shell );
    ReportTime ( "Up", TRUE );

    ReportTime ( "Change Color", FALSE );
    XtVaSetValues ( label, XmNforeground, 15, NULL );

    XmUpdateDisplay ( shell );
    ReportTime ( "Change Color", TRUE );

    XtAppMainLoop ( app );
}

