/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/**********************************************
 * listtest.c: Examine the performance of
 *             various ways to display a list.
 **********************************************/
#include <Xm/Xm.h>
#include <Xm/List.h>
#include <stdlib.h>
#include "TimerTools.h"

Widget CreateList ( Widget parent, int nitems );

void main ( int argc, char **argv )
{
    Widget       shell, list; 
    XtAppContext app;

    shell = XtAppInitialize ( &app, "List", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

    list = CreateList ( shell, atoi ( argv[1] ) );
    XtRealizeWidget ( shell );
   
    XtAppMainLoop ( app );
}

Widget CreateList (Widget parent, int nItems )
{
    int       i;
    Widget    list;
    XmString *xmstr;

    list = XmCreateScrolledList ( parent, "list", NULL, 0 );
    XtManageChild ( list );

    xmstr = ( XmString * ) XtMalloc ( sizeof ( XmString ) *
                                      nItems );

    ReportTime ("Starting to add items", FALSE);
    for ( i = 0; i < nItems; i++ )
        xmstr[i] = XmStringCreateLocalized ( "A String" );

    XmListAddItems ( list, xmstr, nItems, 0 );

    for ( i = 0; i < nItems; i++ )
        XmStringFree ( xmstr[i] );
    XtFree ( ( char * ) xmstr );

    ReportTime ( "Done", TRUE );
    return ( list );
}

