/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*********************************************
 * manage.c : Show the effect of unmanaging
 *             vs. unmapping vs. destroying.
 *********************************************/
#include <Xm/Xm.h>
#include <Xm/PushB.h> 
#include <Xm/RowColumn.h>

static void UnmanageCallback ( Widget, XtPointer,
                                   XtPointer ); 
static void ManageCallback ( Widget, XtPointer,
                                 XtPointer ); 
static void UnmapCallback ( Widget, XtPointer,
                            XtPointer ); 
static void MapCallback ( Widget, XtPointer,
                          XtPointer ); 
static void DestroyCallback ( Widget, XtPointer,
                             XtPointer ); 
static void CreateCallback ( Widget, XtPointer,
                             XtPointer ); 

Widget target = NULL;

void main ( int argc, char **argv )
{
    Widget       shell, rc, create, destroy;
    Widget       map, manage, unmanage, unmap;
    XtAppContext app;

    shell = XtAppInitialize ( &app, "Manage", NULL, 0, 
                              &argc, argv, NULL, NULL, 0 );

   /*
    * Create a RowColumn widget.
    */

    rc = XtCreateManagedWidget ( "rc",
                                 xmRowColumnWidgetClass,
                                 shell, NULL, 0 );

   /*
    * Add children to the Row widget.
    */

    map = XtCreateManagedWidget ( "map",
                                  xmPushButtonWidgetClass,
                                  rc, NULL, 0 );
    unmap = XtCreateManagedWidget ( "unmap",
                                    xmPushButtonWidgetClass,
                                    rc, NULL, 0 );

    target = XtCreateManagedWidget ( "target",
                                     xmPushButtonWidgetClass,
                                     rc, NULL, 0 );

    manage = XtCreateManagedWidget ( "manage",
                                     xmPushButtonWidgetClass,
                                     rc, NULL, 0 );
    unmanage = XtCreateManagedWidget ( "unmanage",
                                       xmPushButtonWidgetClass,
                                       rc, NULL, 0 );
    create = XtCreateManagedWidget ( "create",
                                     xmPushButtonWidgetClass,
                                     rc, NULL, 0 );
    destroy = XtCreateManagedWidget ( "destroy",
                                      xmPushButtonWidgetClass,
                                      rc, NULL, 0 );

    XtAddCallback ( map, XmNactivateCallback,
                    MapCallback, NULL );
    XtAddCallback ( unmap, XmNactivateCallback,
                    UnmapCallback, NULL );
    XtAddCallback ( manage, XmNactivateCallback,
                    ManageCallback, NULL );
    XtAddCallback ( unmanage, XmNactivateCallback,
                    UnmanageCallback, NULL );
    XtAddCallback ( create, XmNactivateCallback,
                    CreateCallback, ( XtPointer ) rc );
    XtAddCallback ( destroy, XmNactivateCallback,
                    DestroyCallback, NULL );

    XtRealizeWidget ( shell );
    XtAppMainLoop ( app ); 
}
 void CreateCallback ( Widget    w,
                       XtPointer clientData,
                       XtPointer callData )
{
    Widget parent = ( Widget ) clientData;

    target = XtCreateManagedWidget ( "target",
                                     xmPushButtonWidgetClass,
                                     parent, NULL, 0 );
}
 void DestroyCallback ( Widget    w,
                        XtPointer clientData,
                        XtPointer callData )
{
    XtDestroyWidget ( target );
    target = NULL;
}
 void ManageCallback ( Widget    w,
                      XtPointer clientData,
                      XtPointer callData )
{
    if ( target )
        XtManageChild ( target );
}
void UnmanageCallback ( Widget    w,
                        XtPointer clientData,
                        XtPointer callData)
{
    if ( target )
        XtUnmanageChild ( target );
}
 void MapCallback ( Widget    w,
                    XtPointer clientData,
                    XtPointer callData )
{
    if ( target )
        XtMapWidget ( target );
}
 void UnmapCallback ( Widget    w,
                      XtPointer clientData,
                      XtPointer callData )
{
    if ( target )
        XtUnmapWidget ( target );
}

