/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*********************************************************
 * texlabels.c: Rapidly update a grid of XmText widgets.
 *********************************************************/
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include "TimerTools.h"

Widget labels[10];

Boolean UpdateLabels ( XtPointer clientData );


void main ( int argc, char **argv ) 
{
    Widget       rc, shell;
    XtAppContext app;
    int          i;

    ReportTime ( "Starting", FALSE );
    
    shell = XtAppInitialize ( &app, "Labels",         
                              NULL, 0,
                              &argc, argv, NULL, NULL, 0 );

    rc = XtVaCreateManagedWidget ( "rc",
                                   xmRowColumnWidgetClass,
                                   shell,
                                   XmNnumColumns, 2,
                                   XmNpacking, XmPACK_TIGHT,
                                   NULL);

    for ( i = 0; i < 10; i++ )
      labels[i] = XtCreateManagedWidget ( "label",
                                      xmTextWidgetClass,
                                      rc, NULL, 0 );
    XtRealizeWidget ( shell );
    XtAppAddWorkProc ( app, UpdateLabels, NULL );
    XtAppMainLoop ( app );
}

Boolean UpdateLabels ( XtPointer clientData )
{
    static int count = 0;
    XmString   xmstr;
    int        i;
    char       buf[20];

    sprintf ( buf, "%d", count %2 ? 10 : 10000000 );
  
    for ( i = 0; i < 10; i++ )
        XtVaSetValues ( labels[i], XmNvalue, buf, NULL );
   
    if ( count++ > 100 )
    {
        ReportTime ( "Done", TRUE );
        return ( TRUE );
    }

    return ( FALSE );
}

