/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/****************************************************
 * widgetlabels.c: Rapidly update a grid of labels.
 ****************************************************/
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include "TimerTools.h"

Widget labels[10];

Boolean UpdateLabels ( XtPointer clientData );

void main ( int argc, char **argv ) 
{
    Widget       rc, shell;
    XtAppContext app;
    int          i;

    ReportTime ( "Starting", FALSE );
    shell = XtAppInitialize ( &app, "Widgetlabels", NULL, 0,
                              &argc, argv, NULL, NULL, 0 );

    rc = XtVaCreateManagedWidget ( "rc",
                                   xmRowColumnWidgetClass,
                                   shell,
                                   XmNnumColumns, 2,
                                   XmNpacking, XmPACK_TIGHT,
                                   NULL );

    for ( i = 0; i < 10; i++ )
       labels[i] = XtCreateManagedWidget ( "label",
                                           xmLabelWidgetClass,
                                           rc, NULL, 0 );
    XtRealizeWidget ( shell );

   /*
    * Install a work procedure to update each label
    * as quickly as possible.
    */

    XtAppAddWorkProc ( app, UpdateLabels, NULL );
    XtAppMainLoop ( app );
}

Boolean UpdateLabels ( XtPointer clientData )
{
    static int count = 0;
    XmString   xmstr;
    int        i;
    char       buf[20];

   /*
    * Create a varying label to display.
    */

    sprintf ( buf, "%d", count %2 ? 10 : 1000000000 );
  
   /*
    * Display the label in each widget.
    */

    for ( i = 0; i < 10; i++ )
    {
        xmstr = XmStringCreateLocalized ( buf );

        XtVaSetValues ( labels[i], 
                        XmNlabelString, xmstr,
                        NULL );

         XmStringFree ( xmstr );
    }
  
   /*
    * Terminate the test if the labels have been 
    * updated 100 times.
    */

    if ( count++ > 100 )
    {
        ReportTime ( "Done", TRUE );
        return ( TRUE );
    }

    return ( FALSE );
}

