/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/************************************************************
 * fractal.h: Type declarations used in the fractal program.
 ************************************************************/
#include <Xm/Xm.h>

typedef struct {
     double  real, imag;
} ComplexNumber;

/*
 * Assorted information needed to generate and draw the image.
 */

typedef struct {
    Widget         canvas;
    Pixmap         pixmap;
    GC             gc;
    GC             xorGC;
    Dimension      width, height;
    int            depth, ncolors;
    double         range, maxDistance;
    ComplexNumber  origin;
    Boolean        restart;
} ImageData;

