/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*****************************************************
 * browser.c: main dirview interface.
 *****************************************************/
#include <Xm/Xm.h>
#include <Xm/MainW.h> 
#include <Xm/RowColumn.h>
#include <Xm/Label.h> 
#include <unistd.h>
#include <stdio.h>
#include "globals.h"
#include "TimerTools.h"

/*
 * Externally-defined functions
 */

extern Widget CreateMenu ( Widget );
extern Widget CreateIcon ( char *, Widget, FileType );

/*
 * label widget that displays current directory.
 */

static Widget currentDirLabel;


void SetCurrentDirectory ( char *dir )
{
    char buf[300];

   /*
    * Just display the given directory in a label.
    */

    sprintf ( buf, "Current Directory: %s", dir );
  
    XtVaSetValues ( currentDirLabel,
                    XtVaTypedArg,
                    XmNlabelString,  XmRString,
                    buf, strlen ( buf ) + 1,
                    NULL );
}


Widget CreateBrowser ( Widget parent, char *dir )
{
    Widget         mainWindow, rowColumn, commandPanel, menuBar;
    struct dirent *entry;
    DIR           *fd;


    ReportTime ( "Starting Browser", TRUE );

   /*
    * No directory is interpreted as meaning the current
    * directory. Determine the directory to be displayed, 
    * and open it.
    */

    if ( !dir )
        dir = getcwd ( NULL, 300 );
  
    if ( ( fd = opendir ( dir ) ) == NULL )
        return ( NULL );    
   
   /*
    * Create widgets for this window.
    */

    mainWindow = XtVaCreateWidget ( "browser",
                        xmMainWindowWidgetClass,   parent,
                        XmNscrollingPolicy,        XmAUTOMATIC,
                        XmNscrollBarDisplayPolicy, XmSTATIC,
                        XmNcommandWindowLocation, 
                                     XmCOMMAND_ABOVE_WORKSPACE,
                        NULL );

    menuBar = CreateMenu ( mainWindow );

    rowColumn = XtVaCreateManagedWidget  ( "rowColumn",
                                  xmRowColumnWidgetClass,
                                  mainWindow,
                                  XmNpacking,    XmPACK_COLUMN,
                                  XmNnumColumns, 8,
                                  NULL );

    commandPanel = XtVaCreateManagedWidget ( "commandPanel",
                       xmRowColumnWidgetClass, mainWindow, 
                       XmNorientation,    XmHORIZONTAL,
                       XmNentryAlignment, XmALIGNMENT_CENTER,
                       XmNpacking,        XmPACK_TIGHT,
                       NULL );

    currentDirLabel = XtVaCreateManagedWidget  ( "label1",
                     xmLabelWidgetClass, commandPanel,
                     XmNentryAlignment,  XmALIGNMENT_BEGINNING,
                     NULL );

    SetCurrentDirectory ( dir );

    XtVaSetValues ( mainWindow,
		    XmNcommandWindow, commandPanel,
		    XmNworkWindow, rowColumn,
		    NULL);    

   /*
    * Read each item in the directory, and create an icon
    * for each item according to its type.
    */

    while ( ( entry = readdir ( fd ) ) != NULL )
    {
        Widget icon;

        icon = CreateIcon ( entry->d_name,
                            rowColumn, 
                            GetType ( entry->d_name ) );
        XtManageChild ( icon );
    }

    ReportTime ( "Icons Created", TRUE );

    return ( mainWindow );
}

