/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*****************************************************
 * main.c: main driver for dirview program.
 *****************************************************/
#include <Xm/Xm.h>
#include <stdlib.h>
#include "TimerTools.h"

extern Widget CreateBrowser ( Widget shell, char *dir );

main ( int argc, char **argv ) 
{
    Widget       shell, browser;
    XtAppContext app ;
    char        *directory = NULL;

    ReportTime ( "Starting", FALSE );
    
    shell = XtAppInitialize  (  &app, "Dirview",  NULL, 0, 
                                &argc, argv, NULL, NULL, 0  );

   /*
    * Retrieve the directory to browse from the 
    * optional command-line argument. If directory is NULL,
    * CreateBrowser() opens the current working directory.
    */

    if ( argc > 1 )
        directory = argv[1];

   /*
    * Create the browser window. This function returns NULL
    * if the given directory cannot be opened.
    */

    if ( ( browser = 
               CreateBrowser ( shell, directory ) ) == NULL )
        exit ( 1 );
    
    XtManageChild ( browser );

    XtRealizeWidget ( shell );

    WaitForWindow ( shell );
    HandleEvents ( shell );
    ReportTime ( "Up", TRUE );
    
    XtAppMainLoop ( app );
}

