/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/********************************************************
 * select.c: Functions for manging the selected icon
 ********************************************************/
#include <Xm/Xm.h>
#include "globals.h"

extern void LaunchEditor ( Display *dpy, char *file );
extern void LaunchNewBrowser ( Display *dpy, char *file );

static Widget selectedWidget = NULL;

/*
 * Access functions
 */

void SetSelectedWidget ( Widget w )
{
    selectedWidget = w;
}

Widget GetSelectWidget()
{
    return ( selectedWidget );
}

void OpenSelected()
{
    if ( selectedWidget )
    {
        Widget   parent = XtParent ( selectedWidget );
        Display *dpy = XtDisplay ( parent );
        XmString label;
        char    *text;
      
       /*
        * Get the label of the selected widget.
        */

        XtVaGetValues ( selectedWidget, 
                        XmNlabelString, &label,
                        NULL );

       /*
        * Get the text of the compound string.
        */

        XmStringGetLtoR ( label,
                          XmFONTLIST_DEFAULT_TAG,
                          &text );
       /*
        * Handle the file or directory depending on type.
        */

        if ( GetType ( text ) == DIRECTORY )
            LaunchNewBrowser ( dpy, text );
        else
            LaunchEditor ( dpy, text );

        XtFree ( text );
    }
}

