/********************************************************************
 *         This example code is from the book:
 *
 *           Motif Debuggin and Performance Tuning
 *            ISBN 0-13-147984-9
 *         by
 *           Douglas Young
 *           Prentice Hall, 1995
 *
 *         Copyright 1994 by Prentice Hall
 *         All Rights Reserved
 *
 *  Permission to use, copy, modify, and distribute this software for 
 *  any purpose except publication and without fee is hereby granted, provided 
 *  that the above copyright notice appear in all copies of the software.
 * *****************************************************************************/

/*************************************************************
 * icons.c: Create an icon to represent a file or directory
 *************************************************************/
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <X11/xpm.h>
#include "icons.h"
#include "globals.h"

extern void SetSelectedWidget ( Widget );
extern void OpenSelected(void);

static void SelectCallback ( Widget    w,
                             XtPointer clientData,
                             XtPointer callData)
{
    XmPushButtonCallbackStruct *cbs =
                   ( XmPushButtonCallbackStruct * ) callData;

   /*
    * Always register this icon as the current selected widget.
    */

    SetSelectedWidget ( w );

   /*
    * Open on a double-click
    */

    if ( cbs->click_count > 1 )
        OpenSelected();
}

Widget CreateIcon ( char    *name, 
                    Widget   parent,
                    FileType type )
{
    Widget         icon, label;
    int            status;
    Pixmap         pix, mask;
    XpmAttributes  attributes;
    XpmColorSymbol symbols[5];
    Display       *dpy = XtDisplay(parent);
    Pixel          bg;
  
   /*
    * Create the widgets that make up the icon.
    */

    Widget base = XtVaCreateWidget ( name,
                          xmRowColumnWidgetClass,
                          parent,
                          XmNorientation,    XmVERTICAL,
                          XmNentryAlignment, XmALIGNMENT_CENTER,
                          NULL );
                                   
    icon = XtVaCreateManagedWidget ( name,
                                     xmPushButtonWidgetClass,
                                     base,
                                     XmNlabelType, XmPIXMAP,
                                     XmNshadowThickness, 0,
                                     XmNfillOnArm, FALSE,
                                     NULL );

    XtAddCallback ( icon, XmNactivateCallback,
                    SelectCallback, NULL );

    label = XtVaCreateManagedWidget ( "label",
                                    xmLabelWidgetClass,
                                    base,
				      XmNlabelType, XmSTRING,
				    XtVaTypedArg,		     
				    XmNlabelString, XmRString, name, strlen(name) + 1,
				      NULL);

   /*
    * Retrieve the depth, colormap, and background used by
    * the icon widget and store the results in the
    * corresponding field of an XpmAttributes structure.
    */

    XtVaGetValues ( icon,
                    XmNdepth,      &attributes.depth,
                    XmNcolormap,   &attributes.colormap,
                    XmNbackground, &bg,
                    NULL );

    symbols[0].name  = "background";
    symbols[0].value = NULL;
    symbols[0].pixel = bg;  

    attributes.visual = DefaultVisual ( dpy,
                                        DefaultScreen ( dpy ) );
    attributes.valuemask =  XpmColorSymbols | XpmDepth |
                            XpmColormap | XpmVisual;

    attributes.colorsymbols = symbols;
    attributes.numsymbols   = 1;

   /*
    * Create the pixmap
    */

    status = XpmCreatePixmapFromData ( dpy,
                                  DefaultRootWindow ( dpy ),
                                  type == REGULAR_FILE ? 
                                         fileIcon : dirIcon,
                                  &pix, NULL, &attributes );

   /*
    * If the pixmap was created sucessfully, set the
    * buttons  labelPixmap resource.
    */

    if ( status == XpmSuccess ) 
        XtVaSetValues ( icon, 
                        XmNlabelType,   XmPIXMAP,
                        XmNlabelPixmap, pix,
                        NULL );  

       return ( base );
}

